% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{config_netlify}
\alias{config_netlify}
\title{Create the configuration (file) for Netlify}
\usage{
config_netlify(output = "netlify.toml", new_config = list())
}
\arguments{
\item{output}{Path to the output file, or \code{NULL}. If the file exists and
the R session is interactive, you will be prompted to decide whether to
overwrite the file.}

\item{new_config}{If any default configuration does not apply to your site,
you may provide a list of configurations to override the default. For
example, if you want to use Hugo v0.25.1, you may use \code{new_config =
list(build = list(environment = list(HUGO_VERSION = '0.25.1')))}.}
}
\value{
If \code{output = NULL}, a character vector of TOML data representing
  the configurations (which you can preview and decide whether to write it to
  a file), otherwise the TOML data is written to a file.
}
\description{
This function provides some default configurations for a Huge website to be
built via Hugo and deployed on Netlify. It sets the build command for the
production and preview contexts, respectively (for preview contexts such as
\samp{deploy-preview}, the command will build future posts). It also sets the
publish directory according to your setting in Hugo's config file (if it
exists, otherwise it will be the default \file{public} directory). The Hugo
version is set to the current version of Hugo found on your computer.
}
\examples{
blogdown::config_netlify(output = NULL)  # default data

# change the publish dir to 'docs/'
blogdown::config_netlify(NULL, list(build = list(publish = "docs")))
}
\references{
See Netlify's documentation on the configuration file
  \file{netlify.toml} for the possible settings:
  \url{https://docs.netlify.com/configure-builds/file-based-configuration/}
}
