% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/blocks.r
\name{blocks}
\alias{blocks}
\title{Block designs}
\usage{
blocks(treatments, replicates, blocklevels = HCF(replicates),
  searches = max(1, 100 - sum(treatments) - prod(blocklevels)),
  seed = sample(10000, 1), jumps = 1)
}
\arguments{
\item{treatments}{the total required number of treatments partitioned into sets of equally replicated treatments.}

\item{replicates}{the replication numbers for the individual treatment sets defined above.}

\item{blocklevels}{the block factor levels taken in nested block order from highest to lowest. The default is the hcf of the replication numbers.}

\item{searches}{the maximum number of local optima searched for a design optimization. The default is the maximum of 1 or (100 - total model terms).}

\item{seed}{an integer initializing the random number generator. The default is a random seed.}

\item{jumps}{the number of pairwise random treatment swaps used to escape a local maxima. The default is a single swap.}
}
\value{
\item{Design}{Data frame showing the optimized block and treatment factors in plot order}
\item{Plan}{Data frame showing a plan view of the treatments in the bottom stratum of the design}
\item{Incidences}{Blocks-by-treatments incidence matrices in each stratum of the design}
\item{Efficiencies}{The achieved A- and D-efficiencies for each stratum of the design together with an A-efficiency upper-bound, where available}
\item{seed}{Numerical seed for random number generator}
\item{searches}{Maximum number of searches in each stratum}
\item{jumps}{Number of random treatment swaps to escape a local maxima}
}
\description{
Constructs randomized nested block designs for unstructured treatments with arbitrary replication, not necessarily all equal,
and arbitrary depth of nesting.
}
\details{
The \code{blocks} function optimizes nested blocks designs where treatments can have any arbitrary level of replication, not necessarily all equal,
and blocks can be either a simple main blocks design or a nested blocks design with any feasible depth of nesting.

The \code{treatments} and \code{replicates} arguments, taken together, define the treatment structure of the design.
\code{treatments} partitions the total required number of treatments into sets of equally replicated treatments and
\code{replicates} gives the actual replication level for each individual treatment set. The \code{treatments} and
 the \code{replicates} arguments must be of equal
 length and must be in matching order.
The sum of the \code{treatments} sets is the total number of treatments and the sum of the cross-products of the \code{treatments} sets
 and the \code{replicates} numbers is the total number of units.
 Treatments are numbered consecutively according to the number of treatments in each set and different treatment sets with the same
 replication number are permitted, if required. Single replicate treatments sets are permitted.

\code{blocklevels} are the levels of the blocks factors taken in order from the highest to the lowest strata.
The first level is the number of main blocks, the second, if any, is the number of sub-blocks nested in each main block, the third, if any,
is the number of sub-sub-blocks nested in each sub-block and so on. The default is a main blocks design with the maximum possible number of
orthogonal main blocks (the highest common factor of the replication numbers).
Block sizes are equal wherever possible and will never differ by more than a single unit in any particular stratum of the design.

The \code{searches} argument is the maximum number of searches during an optimization. The default is the maximum of 1 or (100 - sum of model terms).

The \code{jumps} argument is the number of random swaps needed to escape a local maxima. The default is one.

The \code{blocks} function generates three main classes of design:

\itemize{

\item Complete randomized blocks where each block contains one or more complete sets of treatments in randomized order. Complete blocks can contain multiple
complete randomized sets of treatments but the number of blocks must always divide the hcf of the replication numbers.

\item Lattice designs for k replicates of v**2 treatments with k complete main blocks of size v**2 and v incomplete blocks of size v in each main block.
 Lattice block designs are constructed algebraically from sets of k mutually orthogonal Latin squares of size v x v and \code{blocks}
 constructs designs for any k < (v+2) where v is prime or prime-power, any k < 5 where v = 10 or any k < 4 generally.
 If v is a prime-power, the \code{\link[crossdes]{MOLS}} package is required.

\item  General block designs with arbitrary block levels and arbitrary depth of nesting. General block designs are
 constructed by a D-optimality swapping algorithm that makes improving swaps between
 blocks until a local optima is atttained and no further improvement is possible. The algorithm works from the top stratum downwards and
 always constrains improving swaps within the levels of any existing higher level blocks.
 For repeated \code{searches}, a local maxima is escaped by one or more random swaps (\code{jumps}) between blocks, again constrained
 within the levels of any existing higher level blocks. Blocks are optimized from the top down and
 all nested blocks are conditional on all higher level blocks. Single replicate treatments are excluded
 from the design during optimization and are then added back after optimization using a simple heuristic that requires
 single replicate treatments to be distributed as evenly as possible between blocks.

}

 The principle design outputs comprise:
\itemize{
 \item  A design matrix showing the allocation of treatments to blocks with successive nested blocks factors arranged in successive columns in standard block order.  \cr
 \item  A design matrix as above but with the last (bottom) blocks factor shown arranged horizontally to give a plan view. \cr
 \item  A set of incidence matrices, one for each blocks stratum, showing the number of times each treatment occurs in each block for each stratum. \cr
 \item  A table showing the achieved D- and A-efficiency factors for each nested blocks stratum together with an A-efficiency upper bound, where available. \cr
}
}
\examples{
# 3 treatments x 2 replicates, 2 treatments x 4 replicates and 4 treatments x 3 replicates
# the hcf of the replication numbers is 1 therefore the default design is completely randomized
blocks(treatments=c(3,2,4),replicates=c(2,4,3))

# 4 treatments x 4 replicates with 2 main blocks each containing two complete replicates
blocks(treatments=4,replicates=4,blocklevel=2)

# 50 treatments x 4 replicates with 4 main blocks and 5 nested sub-blocks in each main block
blocks(treatments=50,replicates=4,blocklevels=c(4,5))

# as above but with 20 additional single replicate treatments
# giving exactly one single replicate treatment per sub-block
blocks(treatments=c(50,20),replicates=c(4,1),blocklevels=c(4,5))

# 64 treatments x 2 replicates with 2 main blocks and five succesively nested 2-level factors
blocks(treatments=64,replicates=2,blocklevels=c(2,2,2,2,2,2))

# concurrence matrix of balanced incomplete block design
crossprod(blocks(13,4,13,searches=100)$Incidences[[1]])

# concurrence matrix for 13 treatments x 4 replicates and 13 treatments with one rep in 13 blocks
crossprod(blocks(c(13,13),c(4,1),13)$Incidences[[1]])

# 2**10 treatments x 2 replicates in 2**10 blocks giving a fully saturated blocks design
# (takes a longish time to run!)
\dontrun{ blocks(1024,2,rep(2,10)) }
}
\references{
Sailer, M. O. (2013). crossdes: Construction of Crossover Designs. R package version 1.1-1. http://CRAN.R-project.org/package=crossdes
}

