% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_list.R
\name{bm_list}
\alias{bm_list}
\title{Bitmap list object}
\usage{
bm_list(...)
}
\arguments{
\item{...}{\code{\link[=bm_bitmap]{bm_bitmap()}} objects, possibly named.}
}
\value{
A named list with a \dQuote{bm_list} subclass.
}
\description{
\code{bm_list()} creates a bitmap list object.
}
\details{
\code{bm_list()} is a list of \code{\link[=bm_bitmap]{bm_bitmap()}} objects with class \dQuote{bm_list}.
It is superclass of \code{\link[=bm_font]{bm_font()}}.
}
\section{Supported S3 methods}{

\itemize{
\item \code{as.list.bm_list()}
\item Slicing with \verb{[]} returns \code{bm_list()} objects.
\item The \code{min()}, \code{max()}, and \code{range()} functions from the \dQuote{Summary}
group of generic methods.
}
}

\examples{
 font_file <- system.file("fonts/spleen/spleen-8x16.hex.gz", package = "bittermelon")
 font <- read_hex(font_file)

 gl <- font[c("U+0023", "U+0052", "U+0053", "U+0054", "U+0041", "U+0054", "U+0053")] # #RSTATS
 gl <- as_bm_list(gl)
 is_bm_list(gl)

}
\seealso{
\code{\link[=is_bm_list]{is_bm_list()}}, \code{\link[=as_bm_list]{as_bm_list()}}
}
