% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginal_lik.R
\encoding{UTF-8}
\name{marginal_lik}
\alias{marginal_lik}
\title{Calculate marginal likelihood by thermodynamic integration (LTI)}
\usage{
marginal_lik(mcmc.log, burnin = 0, method = "SS")
}
\arguments{
\item{mcmc.log}{the output file of a \code{\link{mcmc_bite}} run}

\item{burnin}{number or proportion of iteration to delete}

\item{method}{one of "TI" for thermodynamic integration and "SS" for stepping stone integration (the default)}
}
\value{
a length one numeric double giving the marginal likelihood of the model.
}
\description{
Calculate the marginal likelihood from a logfile generated by \code{\link{mcmc_bite}} with thermodynamic integration (Lartillot and Philippe, 2006) or stepping stone (Xie et al., 2011).
}
\examples{
## Load test data
data(Anolis_traits)
data(Anolis_tree)
data(Anolis_map)

## Run a MCMC chain with thermodynamic Integration
set.seed(300)
my.jive <- make_jive(Anolis_tree, Anolis_traits[,-3],
  model.priors = list(mean="BM", logvar="OU"))
bite_ex <- tempdir()
logfile <- sprintf("\%s/my.jive_mcmc_TI.log", bite_ex)
mcmc_bite(my.jive, log.file=logfile, ncat=10, sampling.freq=10,
 print.freq=100, ngen=1000, burnin=0) 
 
## import the results in R
res <- read.csv(logfile, header = TRUE, sep = "\\t")
 
mlikTI <- marginal_lik(res, burnin = 0.1, method = "TI")
mlikTI

mlikSS <- marginal_lik(res, burnin = 0.1, method = "SS")
mlikSS
}
\author{
Theo Gaboriau and Simon Joly
}
