% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/birp.R
\name{plot.birp}
\alias{plot.birp}
\title{Plotting a birp object}
\usage{
\method{plot}{birp}(
  x,
  shadingIncrease = NA,
  shadingDecrease = "#f2c7c7",
  col = "black",
  lwd = 1,
  lty = 1:x$num_gamma,
  xlim = NA,
  ylim = NA,
  add = FALSE,
  xlab = expression(gamma),
  ylab = "Posterior density",
  legend = x$gamma_names,
  lineAtZero = TRUE,
  ...
)
}
\arguments{
\item{x}{A birp object}

\item{shadingIncrease}{Shading color for the range gamma > 0. If \code{NA}, shading is omitted}

\item{shadingDecrease}{Shading color for the range gamma < 0. If \code{NA}, shading is omitted}

\item{col}{Line color, one per gamma. If a single value is provided, it is recycled to match the number of gammas.}

\item{lwd}{Line width, one per gamma. If a single value is provided, it is recycled to match the number of gammas.}

\item{lty}{Line type, one per gamma. If a single value is provided, it is recycled to match the number of gammas.}

\item{xlim}{The x-limits (x1, x2) of the plot. If NA, these are determined automatically}

\item{ylim}{The y-limits (y1, y2) of the plot. If NA, these are determined automatically}

\item{add}{If \code{TRUE}, posterior density is added to currently open plot. If FALSE, a new plot is opened.}

\item{xlab}{Name of x axis}

\item{ylab}{Name of y axis}

\item{legend}{Add a legend to the plot. Use NA to suppress}

\item{lineAtZero}{If \code{TRUE}, adds a dashed line indicating 0.}

\item{...}{additional parameters passed to the function.}
}
\value{
No return value, called for side effects.
}
\description{
Plotting a birp object
}
\examples{
data <- simulate_birp()
est <- birp(data)
plot(est)
}
\seealso{
\code{\link{birp}}
}
