% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpful.functions.R
\name{treatment.effect}
\alias{treatment.effect}
\title{Calculate patient-specific treatment effect}
\usage{
treatment.effect(
  ipd = NULL,
  samples = NULL,
  newpatient = NULL,
  reference = NULL,
  quantiles = c(0.025, 0.5, 0.975)
)
}
\arguments{
\item{ipd}{IPD object created from running ipdma.model type function}

\item{samples}{MCMC samples found from running ipd.run function}

\item{newpatient}{covariate values of patients that you want to predict treatment effect on. Must have length equal to total number of covariates.}

\item{reference}{reference group used for finding patient-specific treatment effect. This is only used for deft approach}

\item{quantiles}{quantiles for credible interval of the patient-specific treatment effect}
}
\value{
patient-specific treatment effect with credible interval at specified quantiles
}
\description{
Function for calculating the patient-specific treatment effect.
Patient-specific treatment effect includes the main effect of treatment and 
treatment-covariate interaction effect (i.e. effect modification). 
Reports odds ratio for the binary outcome.
}
\examples{
ds <- generate_ipdma_example(type = "continuous")
ipd <- with(ds, ipdma.model.onestage(y = y, study = studyid, treat = treat, X = cbind(z1, z2), 
response = "normal", shrinkage = "none"))
\donttest{
samples <- ipd.run(ipd, pars.save = c("beta", "gamma", "delta"), n.chains = 3, n.burnin = 500, 
n.iter = 5000)
treatment.effect(ipd, samples, newpatient = c(1,0.5))
}
}
\references{
Seo M, White IR, Furukawa TA, et al. Comparing methods for estimating patient-specific treatment effects in individual patient data meta-analysis. \emph{Stat Med}. 2021;40(6):1553-1573. \doi{10.1002/sim.8859}

Riley RD, Debray TP, Fisher D, et al. Individual participant data meta-analysis to examine interactions between treatment effect and participant-level covariates: Statistical recommendations for conduct and planning. \emph{Stat Med}. 2020:39(15):2115-2137. \doi{10.1002/sim.8516}
}
