% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq_stat_operations.R
\name{seq_nchar}
\alias{seq_nchar}
\title{Count the number of character in sequences}
\usage{
seq_nchar(x, gaps = TRUE)
}
\arguments{
\item{x}{a DNA, RNA or AA vector.}

\item{gaps}{if \code{FALSE} gaps are ignored.}
}
\value{
An integer vector giving the size of each sequence of \code{x}.
}
\description{
Count the number of character in sequences
}
\examples{

x <- dna(c("ATGCAGA", "GGR-----","TTGCCTAGKTGAACC"))
seq_nchar(x)
seq_nchar(x, gaps = FALSE)

}
\seealso{
Other op-misc: \code{\link{seq_disambiguate_IUPAC}},
  \code{\link{seq_nseq}}, \code{\link{seq_spellout}},
  \code{\link{seq_stat_gc}}, \code{\link{seq_stat_prop}}
}
\concept{op-misc}
