% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gui_wrappers.R
\name{seaview}
\alias{seaview}
\title{SeaView: DNA sequences and phylogenetic tree viewer}
\usage{
seaview(x, seaview_exec = options("bioseq.seaview.exec"))
}
\arguments{
\item{x}{a DNA, RNA or AA vector.
Alternatively a \code{DNAbin} or \code{AAbin} object or
a phylogenetic tree (class \code{phylo}).}

\item{seaview_exec}{a character string giving the path of the program.}
}
\description{
This function opens SeaView (Gouy, Guindon & Gascuel, 2010)
to visualize biological sequences and phylogenetic trees.
The software must be installed on the computer.
}
\details{
By default, the function assumes that the executable is installed
in a directory located on the PATH. Alternatively the user can provide
an absolute path to the executable (i.e. the location where the software
was installed/uncompressed). This can be stored in the global
options settings using
\code{options(bioseq.seaview.exec = "my_path_to_seaview")}.
}
\references{
Gouy M., Guindon S. & Gascuel O. (2010) SeaView version 4 :
a multiplatform graphical user interface for sequence
alignment and phylogenetic tree building.
Molecular Biology and Evolution 27(2):221-224.
}
\seealso{
Other GUI wrappers: \code{\link{aliview}}
}
\concept{GUI wrappers}
