% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_PseudoAbsences.R
\name{bm_PseudoAbsences}
\alias{bm_PseudoAbsences}
\alias{bm_PseudoAbsences_random}
\alias{bm_PseudoAbsences_sre}
\alias{bm_PseudoAbsences_disk}
\alias{bm_PseudoAbsences_user.defined}
\alias{bm_PseudoAbsences_user.defined,ANY,SpatVector-method}
\alias{bm_PseudoAbsences_user.defined,ANY,SpatRaster-method}
\alias{bm_PseudoAbsences_random,ANY,SpatVector-method}
\alias{bm_PseudoAbsences_random,ANY,SpatRaster-method}
\alias{bm_PseudoAbsences_sre,ANY,SpatVector-method}
\alias{bm_PseudoAbsences_sre,ANY,SpatRaster-method}
\alias{bm_PseudoAbsences_disk,ANY,SpatVector-method}
\alias{bm_PseudoAbsences_disk,ANY,SpatRaster-method}
\title{Select pseudo-absences}
\usage{
bm_PseudoAbsences(
  resp.var,
  expl.var,
  nb.rep = 1,
  strategy = "random",
  nb.absences = NULL,
  sre.quant = 0,
  dist.min = 0,
  dist.max = NULL,
  fact.aggr = NULL,
  user.table = NULL,
  seed.val = NULL
)

bm_PseudoAbsences_user.defined(resp.var, expl.var, ...)

\S4method{bm_PseudoAbsences_user.defined}{ANY,SpatVector}(resp.var, expl.var, user.table)

\S4method{bm_PseudoAbsences_user.defined}{ANY,SpatRaster}(resp.var, expl.var, user.table)

bm_PseudoAbsences_random(resp.var, expl.var, ...)

\S4method{bm_PseudoAbsences_random}{ANY,SpatVector}(resp.var, expl.var, nb.absences, nb.rep, fact.aggr)

\S4method{bm_PseudoAbsences_random}{ANY,SpatRaster}(resp.var, expl.var, nb.absences, nb.rep, fact.aggr)

bm_PseudoAbsences_sre(resp.var, expl.var, ...)

\S4method{bm_PseudoAbsences_sre}{ANY,SpatVector}(resp.var, expl.var, sre.quant, nb.absences, nb.rep)

\S4method{bm_PseudoAbsences_sre}{ANY,SpatRaster}(resp.var, expl.var, sre.quant, nb.absences, nb.rep)

bm_PseudoAbsences_disk(resp.var, expl.var, ...)

\S4method{bm_PseudoAbsences_disk}{ANY,SpatVector}(
  resp.var,
  expl.var,
  dist.min,
  dist.max,
  nb.absences,
  nb.rep,
  fact.aggr
)

\S4method{bm_PseudoAbsences_disk}{ANY,SpatRaster}(
  resp.var,
  expl.var,
  dist.min,
  dist.max,
  nb.absences,
  nb.rep,
  fact.aggr
)
}
\arguments{
\item{resp.var}{a \code{vector}, \code{\link[sp]{SpatialPoints}} or 
\code{\link[sp]{SpatialPointsDataFrame}} object containing binary data (\code{0} : absence, 
\code{1} : presence, \code{NA} : indeterminate) for a single species that will be used to 
find the pseudo-absences}

\item{expl.var}{a \code{matrix}, \code{data.frame}, \code{\link[sp]{SpatialPointsDataFrame}} 
or \code{\link[terra:rast]{SpatRaster}} object containing the explanatory variables (in 
columns or layers) that will be used to find the pseudo-absences}

\item{nb.rep}{an \code{integer} corresponding to the number of sets (repetitions) of 
pseudo-absence points that will be drawn}

\item{strategy}{a \code{character} corresponding to the pseudo-absence selection strategy, 
must be among \code{random}, \code{sre}, \code{disk} or \code{user.defined}}

\item{nb.absences}{(\emph{optional, default} \code{NULL}) \cr
If \code{strategy = 'random'} or \code{strategy = 'sre'} or \code{strategy = 'disk'}, an 
\code{integer} corresponding to the number of pseudo-absence points that will be selected for 
each pseudo-absence repetition (true absences included)}

\item{sre.quant}{(\emph{optional, default} \code{0}) \cr
If \code{strategy = 'sre'}, a \code{numeric} between \code{0} and \code{0.5} defining the 
half-quantile used to make the \code{sre} pseudo-absence selection (see \code{\link{bm_SRE}})}

\item{dist.min}{(\emph{optional, default} \code{0}) \cr
If \code{strategy = 'disk'}, a \code{numeric} defining the minimal distance to presence points 
used to make the \code{disk} pseudo-absence selection (in the same projection system units as 
\code{expl.var})}

\item{dist.max}{(\emph{optional, default} \code{NULL}) \cr
If \code{strategy = 'disk'}, a \code{numeric} defining the maximal distance to presence points 
used to make the \code{disk} pseudo-absence selection (in the same projection system units as 
\code{expl.var})}

\item{fact.aggr}{(\emph{optional, default} \code{NULL}) \cr
If \code{strategy = 'random'} or \code{strategy = 'disk'}, a \code{integer} defining the 
factor of aggregation to reduce the resolution}

\item{user.table}{(\emph{optional, default} \code{NULL}) \cr
If \code{strategy = 'user.defined'}, a \code{matrix} or \code{data.frame} with as many rows as 
\code{resp.var} values, as many columns as \code{nb.rep}, and containing \code{TRUE} or 
\code{FALSE} values defining which points will be used to build the species distribution 
model(s) for each repetition}

\item{seed.val}{(\emph{optional, default} \code{NULL}) \cr 
An \code{integer} value corresponding to the new seed value to be set}

\item{\ldots}{(\emph{optional, one or several of the above arguments depending on the selected 
method})}
}
\value{
A \code{list} containing the following elements :
\itemize{
  \item \code{xy} : the coordinates of the species observations
  \item \code{sp} : the values of the species observations (\code{0}, \code{1} or \code{NA})
  \item \code{env} : the explanatory variables
  \item \code{pa.tab} : the corresponding table of selected pseudo-absences (indicated by 
  \code{TRUE} or \code{FALSE})
}
}
\description{
This internal \pkg{biomod2} function allows to select pseudo-absences according 
to 4 different methods : \code{random}, \code{sre}, \code{disk} or \code{user.defined} (see Details).
}
\details{
\bold{Concerning random selection :}

The idea is to select pseudo-absences randomly in spatial locations where the species has not 
been sampled. This method is the simplest one and the most appropriate if lacking information 
about the presence sampling (non-exhaustive, biased sampling, etc). \cr \cr

\bold{Concerning SRE selection (see \code{\link{bm_SRE}}) :}

The idea is to select pseudo-absences in spatial locations whose environmental conditions are 
different from those of the presence points. This method is appropriate when most of the 
environmental space of the species has been sampled. \cr \cr

\bold{Concerning disk selection :}

The idea is to select pseudo-absences, not too close from presence points, but not too far 
away either. This method is appropriate when most of the spatial range of the species has 
been sampled. \cr \cr

\bold{Concerning user defined selection :}

The user can provide pseudo-absences locations through a table containing spatial locations 
in rows, pseudo-absences repetitions in columns, and \code{TRUE/FALSE} values indicating 
whether each point is to be considered as pseudo-absence or not for each dataset.
}
\examples{
library(terra)

# Load species occurrences (6 species available)
data(DataSpecies)
head(DataSpecies)

# Select the name of the studied species
myRespName <- 'GuloGulo'

# Get corresponding presence/absence data
myResp <- as.numeric(DataSpecies[, myRespName])

# Get corresponding XY coordinates
myRespXY <- DataSpecies[, c('X_WGS84', 'Y_WGS84')]

# Load environmental variables extracted from BIOCLIM (bio_3, bio_4, bio_7, bio_11 & bio_12)
data(bioclim_current)
myExpl <- terra::rast(bioclim_current)

\dontshow{
myExtent <- terra::ext(0,30,45,70)
myExpl <- terra::crop(myExpl, myExtent)
}


# --------------------------------------------------------------- #
# Create the different pseudo-absence datasets

# Transform true absences into potential pseudo-absences
myResp.PA <- ifelse(myResp == 1, 1, NA)
myResp.PA.vect <- vect(cbind(myRespXY, myResp.PA), geom = c("X_WGS84","Y_WGS84"))

# random method
PA.r <- bm_PseudoAbsences(resp.var = myResp.PA.vect,
                          expl.var = myExpl,
                          nb.rep = 4,
                          nb.absences = 1000,
                          strategy = 'random')

# disk method
PA.d <- bm_PseudoAbsences(resp.var = myResp.PA.vect,
                          expl.var = myExpl,
                          nb.rep = 4,
                          nb.absences = 500,
                          strategy = 'disk',
                          dist.min = 5,
                          dist.max = 35)

# SRE method
PA.s <- bm_PseudoAbsences(resp.var = myResp.PA.vect,
                          expl.var = myExpl,
                          nb.rep = 4,
                          nb.absences = 1000,
                          strategy = 'sre',
                          sre.quant = 0.025)

# user.defined method
myPAtable <- data.frame(PA1 = ifelse(myResp == 1, TRUE, FALSE),
                        PA2 = ifelse(myResp == 1, TRUE, FALSE))
for (i in 1:ncol(myPAtable)) myPAtable[sample(which(myPAtable[, i] == FALSE), 500), i] = TRUE
PA.u <- bm_PseudoAbsences(resp.var = myResp.PA.vect,
                          expl.var = myExpl,
                          strategy = 'user.defined',
                          user.table = myPAtable)

str(PA.r)
head(PA.r$pa.tab)
apply(PA.r$pa.tab, 2, table)

head(PA.d$pa.tab)
apply(PA.d$pa.tab, 2, table)

head(PA.s$pa.tab)
apply(PA.s$pa.tab, 2, table)

tail(PA.u$pa.tab)
apply(PA.u$pa.tab, 2, table)


# random method : different number of PA
PA.r_mult <- bm_PseudoAbsences(resp.var = myResp.PA.vect,
                               expl.var = myExpl,
                               nb.rep = 4,
                               nb.absences = c(1000, 500, 500, 200),
                               strategy = 'random')

str(PA.r_mult)
head(PA.r_mult$pa.tab)
apply(PA.r_mult$pa.tab, 2, table)


}
\seealso{
\code{\link{bm_SRE}}, \code{\link{BIOMOD.formated.data.PA}}, 
\code{\link{BIOMOD_FormatingData}}

Other Secondary functions: 
\code{\link{bm_BinaryTransformation}()},
\code{\link{bm_CrossValidation}()},
\code{\link{bm_FindOptimStat}()},
\code{\link{bm_MakeFormula}()},
\code{\link{bm_ModelingOptions}()},
\code{\link{bm_PlotEvalBoxplot}()},
\code{\link{bm_PlotEvalMean}()},
\code{\link{bm_PlotRangeSize}()},
\code{\link{bm_PlotResponseCurves}()},
\code{\link{bm_PlotVarImpBoxplot}()},
\code{\link{bm_RunModelsLoop}()},
\code{\link{bm_SRE}()},
\code{\link{bm_SampleBinaryVector}()},
\code{\link{bm_SampleFactorLevels}()},
\code{\link{bm_Tuning}()},
\code{\link{bm_VariablesImportance}()}
}
\author{
Wilfried Thuiller, Damien Georges
}
\concept{Secondary functions}
\keyword{SRE}
\keyword{disk}
\keyword{pseudo-absence}
\keyword{random}
