% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variogram.r
\name{vario_df}
\alias{vario_df}
\title{Calculate the variogram data frame for a model}
\usage{
vario_df(model.obj, Row, Col)
}
\arguments{
\item{model.obj}{An asreml model}
}
\value{
A data frame with the variogram for a model. The data frame contains the spatial coordinates (typically row and column), the $gamma$ for that position and the number of points with the separation.
}
\description{
Calculate the variogram data frame for a model
}
\examples{
\dontrun{
library(asreml)
oats <- asreml::oats
oats <- oats[order(oats$Row, oats$Column),]
model.asr <- asreml(yield ~ Nitrogen + Variety + Nitrogen:Variety,
                    random = ~ Blocks + Blocks:Wplots,
                    residual = ~ ar1(Row):ar1(Column),
                    data = oats)
vario_df(model.asr)
}

}
\keyword{internal}
