% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nearestneighbourdistribution.R
\name{nearest.neighbour.distribution}
\alias{nearest.neighbour.distribution}
\title{Nearest neighbour distribution (D curve)}
\usage{
nearest.neighbour.distribution(X, Y, Z, X2 = X, Y2 = Y, Z2 = Z,
  same = TRUE, psz = 25, main = "Nearest neighbour distribution",
  file = NULL, return = FALSE)
}
\arguments{
\item{X}{X coordinates of point pattern 1}

\item{Y}{Y coordinates of point pattern 1}

\item{Z}{Z coordinates of point pattern 1}

\item{X2}{X coordinates of point pattern 2}

\item{Y2}{Y coordinates of point pattern 2}

\item{Z2}{Z coordinates of point pattern 2}

\item{same}{binary, FLASE for cross D curve}

\item{psz}{pointsize for discretization}

\item{main}{Title for graphic}

\item{file}{File name for PNG file. If NULL, plots to standard device.}

\item{return}{Logical. Return histogramm?}
}
\value{
histogramm of nearest neighbours
}
\description{
Nearest neighbour distribution (D curve)
}
\examples{
p<-read.csv(system.file("extdata","cell.csv",package="bioimagetools")) 
nearest.neighbour.distribution(p$X,p$Y,p$Z)
}

