## ---- include = FALSE---------------------------------------------------------
library(biodosetools)
knitr::opts_chunk$set(
  fig.dpi = 96,
  collapse = TRUE,
  comment = "#>"
)

## ----sc-trans-estimate-01, echo=FALSE, out.width='100%', fig.align='center', fig.cap="'Curve fitting data options' box and 'Results' tabbed box in the dose estimation module"----
knitr::include_graphics("figures/screenshot-translocations-estimate-01.png")

## ----load-fitting-results, tidy=TRUE, tidy.opts=list(width.cutoff=60)---------
fit_results <- system.file("extdata", "translocations-fitting-results.rds", package = "biodosetools") %>%
  readRDS()

## ----fit-results--------------------------------------------------------------
fit_results$fit_coeffs

## ----sc-trans-estimate-02, echo=FALSE, out.width='100%', fig.align='center', fig.cap="'Stains color options', 'Chromosome data' and 'Genomic conversion factor' boxes in the dose estimation module"----
knitr::include_graphics("figures/screenshot-translocations-estimate-02.png")

## ----trans-genome-factor-est--------------------------------------------------
genome_factor <- calculate_genome_factor(
  dna_table = dna_content_fractions_morton,
  chromosome = c(1, 2, 3, 4, 5, 6),
  color = c("Red", "Red", "Green", "Red", "Green", "Green"),
  sex = "male"
)

## -----------------------------------------------------------------------------
genome_factor

## ----sc-trans-estimate-03, echo=FALSE, out.width='100%', fig.align='center', fig.cap="'Data input options' and 'Data input' boxes in the dose estimation module"----
knitr::include_graphics("figures/screenshot-translocations-estimate-03.png")

## ----trans-case-data----------------------------------------------------------
case_data <- data.frame(
  C0 = 288, C1 = 52, C2 = 9, C3 = 1
) %>%
  calculate_aberr_table(
    type = "case",
    assessment_u = 1
  ) %>%
  dplyr::rename(Fp = mean, Fp_err = std_err) %>%
  dplyr::mutate(
    Xc = calculate_trans_rate_sigurdson(
      cells = N,
      genome_factor = genome_factor,
      age_value = 30,
      smoker_bool = TRUE
    ),
    Fg = (X - Xc) / (N * genome_factor),
    Fg_err = Fp_err / sqrt(genome_factor)
  )

## -----------------------------------------------------------------------------
case_data

## ----sc-trans-estimate-04, echo=FALSE, out.width='60%', fig.align='center', fig.cap="'Dose estimation options' box in the dose estimation module"----
knitr::include_graphics("figures/screenshot-translocations-estimate-04.png")

## ----sc-trans-estimate-05, echo=FALSE, out.width='100%', fig.align='center', fig.cap="'Results' tabbed box, 'Curve plot' and 'Save results' boxes in the dose estimation module"----
knitr::include_graphics("figures/screenshot-translocations-estimate-05.png")

## ----trans-parse-fit-results--------------------------------------------------
fit_coeffs <- fit_results[["fit_coeffs"]]
fit_var_cov_mat <- fit_results[["fit_var_cov_mat"]]

## ----trans-protracted-g-value-------------------------------------------------
protracted_g_value <- protracted_g_function(
  time = 0.5,
  time_0 = 2
)

## -----------------------------------------------------------------------------
protracted_g_value

## ----trans-dose-estimation-whole-delta----------------------------------------
results_whole_delta <- estimate_whole_body_delta(
  case_data,
  fit_coeffs,
  fit_var_cov_mat,
  conf_int = 0.95,
  protracted_g_value,
  aberr_module = "translocations"
)

## ----trans-estimated-dose-curve, fig.width=6, fig.height=3.5, fig.align='center'----
plot_estimated_dose_curve(
  est_doses = list(whole = results_whole_delta),
  fit_coeffs,
  fit_var_cov_mat,
  protracted_g_value,
  conf_int_curve = 0.95,
  aberr_name = "Translocations"
)

