% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_bioint.R
\name{bioint}
\alias{bioint}
\title{Computation of Bioclimatic Intensities}
\usage{
bioint(bb)
}
\arguments{
\item{bb}{Bioclimatic balance.}
}
\value{
data frame with 14 variables: "IBPc","IBPc_g","IBCc","IBLc","IBLc_g","IBRc","IBSc","IBPf","IBPf_g","IBCf","IBLf","IBLf_g","IBRf","IBSf".
}
\description{
Computes bioclimatic intensities from bioclimatic balance.
}
\examples{
wb <- watbal(t = rnorm(12, 18, 6), p = rnorm(12, 50, 30), lat = 35, CC = 400)
bb <- biobal(wb, 400)
bi <- bioint(bb)
}
