% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvol.R
\name{summary.pvol}
\alias{summary.pvol}
\alias{is.pvol}
\alias{dim.pvol}
\title{Inspect a polar volume (\code{pvol})}
\usage{
\method{summary}{pvol}(object, ...)

is.pvol(x)

\method{dim}{pvol}(x)
}
\arguments{
\item{object}{A \code{pvol} object.}

\item{...}{Additional arguments affecting the summary produced.}

\item{x}{A \code{pvol} object.}
}
\value{
For \code{\link[=is.pvol]{is.pvol()}}: \code{TRUE} for an object of class \code{pvol}, otherwise
\code{FALSE}.

For \code{\link[=dim.pvol]{dim.pvol()}}: number of scans (\code{scan}) in a polar volume
(\code{pvol}).
}
\description{
R base functions for inspecting a polar volume (\code{pvol}) object.
}
\details{
A polar volume consists of a number of scans (or sweeps) made by the radar at
different elevation angles. A polar volume (\code{pvol}) object is a list
containing:
\itemize{
\item \code{radar}: Radar identifier.
\item \code{datetime}: Nominal time of the volume in UTC.
\item \code{scans}: List of scans (\code{scan}) at different elevation angles.
\item \code{attributes}: List of the volume's \code{what}, \code{where} and \code{how}
attributes.
\item \code{geo}: List of the volume's geographic properties:
\itemize{
\item \code{lat}: Latitude of the radar in decimal degrees.
\item \code{lon}: Longitude of the radar in decimal degrees.
\item \code{height}: Height of the radar antenna in meters above sea level.
}
}
}
\examples{
# Locate and read the polar volume example file
pvolfile <- system.file("extdata", "volume.h5", package = "bioRad")
pvol <- read_pvolfile(pvolfile)

# Verify that it is an object of class pvol
is.pvol(pvol)

# Get summary info
pvol # Same as summary(pvol) or print(pvol)

# Get dimensions
dim(pvol)

# Get summary info for the scans in the polar volume
pvol$scans
}
\seealso{
\itemize{
\item \code{\link[=read_pvolfile]{read_pvolfile()}}
\item \code{\link[=get_elevation_angles]{get_elevation_angles()}}
\item \code{\link[=get_scan]{get_scan()}}
}
}
