% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regularize_vpts.R
\name{regularize_vpts}
\alias{regularize_vpts}
\title{Regularize a time series of vertical profiles (\code{vpts}) on a
regular time grid}
\usage{
regularize_vpts(
  ts,
  interval = "auto",
  date_min,
  date_max,
  units = "secs",
  fill = TRUE,
  verbose = TRUE,
  keep_datetime = FALSE
)
}
\arguments{
\item{ts}{An object inheriting from class \code{vpts}, see
\code{\link[=summary.vpts]{vpts()}} for details.}

\item{interval}{Time interval grid to project on. When '\code{auto}' the
median interval in the time series is used.}

\item{date_min}{Start time of the projected time series, as a POSIXct object.
Taken from \code{ts} by default'.}

\item{date_max}{End time of the projected time series, as a POSIXct object.
Taken from \code{ts} by default.}

\item{units}{Optional units of \code{interval} and \code{fill}, one of 'secs', 'mins',
'hours','days', 'weeks'. Defaults to 'mins'.}

\item{fill}{Numeric or Logical. fill each regularized timestep with the closest
original profile found within a time window of +/- \code{fill}.
When \code{TRUE}, \code{fill} maps to \code{interval}, filling single missing
timesteps. When \code{FALSE}, \code{fill}  maps to 0, disabling filling.}

\item{verbose}{Logical, when \code{TRUE} prints text to console.}

\item{keep_datetime}{Logical, when \code{TRUE} keep original radar acquisition timestamps.}
}
\value{
An object of class \code{vpts} with regular time steps.
}
\description{
Projects objects of class \code{vpts} on a regular time grid
}
\details{
Projects objects of class \code{vpts} on a regular time grid, and fills
temporal gaps by nearest neighbor interpolation.

Irregular time series of profiles are typically aligned on a
regular time grid with the expected time interval at which a radar provides
data. Alignment is performed using a nearest neighbor interpolation limited to
neighboring profiles that fall within +/- \code{fill} (centered) of an original profile.

Remaining temporal gaps in the time series are filled with empty profiles that have values
NA for all quantities, such that each timestamp of the regular grid has an
associated profile.

In plots of regular time series (see \code{\link[=plot.vpts]{plot.vpts()}}) temporal gaps of
missing profiles (e.g. due to radar down time) become visible, as a result
of the gap filling with empty profiles. In irregular
time series data points in the plot are carried through until the time series
continues, and temporal data gaps are filled up visually.

When \code{keep_datetime} is \code{TRUE} the original profile timestamps are kept in
\code{ts$datetime}. This may lead to duplicate timestamps when regularizing on a timegrid
finer than the interval of available profiles.
}
\examples{
# start form example vpts object:
data(example_vpts)
ts <- example_vpts
# data gaps are not visible:
plot(ts)

# regularize the time series on a 5 minute interval grid
tsRegular <- regularize_vpts(ts, interval = 300)
# data gaps are visible:
plot(tsRegular)

# regularize the time series on a 10 minute interval grid,
# and fill data gaps smaller than 1 hour by nearest neighbor interpolation
tsRegular <- regularize_vpts(ts, interval = 600, fill = 3600)
# data gaps are smaller as a result of nearest neighbor interpolation:
plot(tsRegular)
}
