% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_guarded.R
\name{impute_guarded}
\alias{impute_guarded}
\title{Leakage-safe data imputation via guarded preprocessing}
\usage{
impute_guarded(
  train,
  test,
  method = c("median", "knn", "missForest", "none"),
  constant_value = 0,
  k = 5,
  seed = 123,
  winsor = TRUE,
  winsor_thresh = 3,
  parallel = FALSE,
  return_outliers = FALSE,
  vars = NULL
)
}
\arguments{
\item{train}{data frame (training set)}

\item{test}{data frame (test set)}

\item{method}{one of "median", "knn", "missForest", or "none"}

\item{constant_value}{unused; retained for backward compatibility}

\item{k}{number of neighbors for kNN imputation (if method = "knn")}

\item{seed}{unused; retained for backward compatibility. Set seed before
calling this function if reproducibility is needed.}

\item{winsor}{logical; apply MAD-based winsorization before imputation}

\item{winsor_thresh}{numeric; MAD cutoff (default = 3)}

\item{parallel}{logical; unused (kept for compatibility)}

\item{return_outliers}{logical; unused (outlier flags not returned)}

\item{vars}{optional character vector; impute only selected variables}
}
\value{
A LeakImpute object with imputed data and guard state.
}
\description{
Fits imputation parameters on the training data only, then applies the same
guarded transformation to the test data. This function is a thin wrapper
around the guarded preprocessing used by \code{fit_resample()}.
Output is the transformed feature matrix used by the guarded pipeline
(categorical variables are one-hot encoded).
}
\examples{
train <- data.frame(x = c(1, 2, NA, 4), y = c(NA, 1, 1, 0))
test <- data.frame(x = c(NA, 5), y = c(1, NA))
imp <- impute_guarded(train, test, method = "median", winsor = FALSE)
imp$train
imp$test
}
\seealso{
[fit_resample()], [predict_guard()]
}
