% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binParameters.R
\name{binParameters}
\alias{binParameters}
\title{binParameters}
\usage{
binParameters(scans = 5:12, modes = c("n", "p"), sranges = list(c(70,
  1000)), cls = character(), nCores = detectCores(),
  clusterType = "FORK")
}
\arguments{
\item{scans}{numeric vector containing the scan indexes to use for binning}

\item{modes}{character vector denoting the order and names of the modes}

\item{sranges}{list of vectors containing the ranges of the scan events present}

\item{cls}{the column of class labels to use for aggregating accurate mass data. Defaults to NULL where accurate mass data will be averaged accross all samples}

\item{nCores}{the number of cores to use for parallel processing}

\item{clusterType}{the type of cluster to use for parallel processing}
}
\description{
selection of parameters to use for spectral binning.
}
\examples{
p <- binParameters(scans = 6:17,nCores = 2,clusterType = 'PSOCK')

## Example using multiple overlapping scan ranges
p <- binParameters(scans = 6:17,sranges = list(c(55,280),c(270,1200)))

}
