\name{simul.commonprob}
\alias{simul.commonprob}
\alias{SimulVals}
\title{Simulate Joint Binary Probabilities}
\description{
  Compute common probabilities of binary random variates generated by
  thresholding normal variates at 0.
}
\usage{
simul.commonprob(margprob, corr=0, method="integrate", n1=10^5, n2=10)
}
\arguments{
  \item{margprob}{vector of marginal probabilities.}
  \item{corr}{vector of correlation values for normal distribution.}
  \item{method}{either \code{"integrate"} or \code{"monte carlo"}.}
  \item{n1}{number of normal variates if method is \code{"monte carlo"}.}
  \item{n2}{number of repetitions if method is \code{"monte carlo"}.}
}
\details{
  The output of this function is used by \code{\link{rmvbin}}.  For all
  combinations of \code{marginprob[i]}, \code{marginprob[j]} and
  \code{corr[k]}, the probability that both components of a normal
  random variable with mean \code{qnorm(marginprob[c(i,j)])} and
  correlation \code{corr[k]} are larger than zero is computed.

  The probabilities are either computed by numerical integration of the
  multivariate normal density, or by Monte Carlo simulation.

  For normal usage of \code{\link{rmvbin}} it is not necessary to use
  this function, one simulation result is provided as variable
  \code{SimulVals} in this package and loaded by default.
}
\value{
  \code{simul.commonprob} returns an array of dimension
  \code{c(length(margprob), length(margprob), length(corr))}. 
}
\references{Friedrich Leisch, Andreas Weingessel and Kurt Hornik
  (1998). On the generation of correlated artificial binary
  data. Working Paper Series, SFB ``Adaptive Information Systems and
  Modelling in Economics and Management Science'', Vienna University of
  Economics, \url{http://www.wu-wien.ac.at/am}
}
\author{Friedrich Leisch}
\seealso{
  \code{\link{rmvbin}}
}
\examples{
simul.commonprob(seq(0,1,0.5), seq(-1,1,0.5), meth="mo", n1=10^4)

data(SimulVals)

}
\keyword{distribution}
\keyword{multivariate}
