% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/halving.R
\name{ExpTests.halving}
\alias{ExpTests.halving}
\title{Extract the expected number of tests from testing configuration results}
\usage{
\method{ExpTests}{halving}(object, ...)
}
\arguments{
\item{object}{An object of class "halving", from which the expected number
of tests is to be extracted.}

\item{...}{Additional arguments to be passed to \code{ExpTests} (e.g.,
\code{digits} to be passed to \code{round} for appropriate rounding).}
}
\value{
A data frame containing the columns:
\item{ExpTests}{the expected number of tests required to decode all individuals
in the algorithm.}
\item{ExpTestsPerIndividual}{the expected number of tests per individual.}
\item{PercentReductionTests}{The percent reduction in the number of tests; 100 * (1 - ExpTestsPerIndividual).}
\item{PercentIncreaseTestCap}{The percent increase in testing capacity when the algorithm
  is applied to a continuous stream of specimens; 100 * (1/ExpTestsPerIndividual - 1).}
}
\description{
Extract the expected number of tests from objects of class "halving" returned by
\code{\link{halving}} (\kbd{halving}).
}
\examples{
save.it1 <- halving(p = rep(0.01, 10), Sp = 1, Se = 1, stages = 2,
        order.p = TRUE)
ExpTests(save.it1)
}
\references{
\insertRef{bilder2020tests}{binGroup2}
}
\author{
Christopher R. Bilder
}
