% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OTC1.R
\name{summary.OTC}
\alias{summary.OTC}
\title{Summary method for optimal testing configuration results}
\usage{
\method{summary}{OTC}(object, ...)
}
\arguments{
\item{object}{an object of class \kbd{"OTC"}, providing the optimal testing 
configuration and associated operating characteristics for a group testing 
algorithm.}

\item{...}{currently not used.}
}
\value{
\kbd{summary.OTC} returns an object of class \kbd{"summary.OTC"}, 
a list containing:
\item{Algorithm}{character string specifying the name of the group testing 
algorithm.}
\item{OTC}{matrix detailing the optimal testing configuration from 
\kbd{object}. For hierarchical testing, this includes the group sizes for 
each stage of testing. For array testing, this includes the array dimension 
(row/column size) and the array size (the total number of individuals 
in the array).}
\item{Tests}{matrix detailing the expected number of tests and expected 
number of tests per individual from \kbd{object}}.
\item{Accuracy}{matrix detailing the overall accuracy measures for the 
algorithm, including the pooling sensitivity, pooling specificity, 
pooling positive predictive value, and pooling negative predictive value 
for the algorithm from \kbd{object}. Further details are found in the 
'Details' section.}
}
\description{
Produce a summary list for objects of class \kbd{"OTC"} 
returned by \code{\link{OTC1}} or \code{\link{OTC2}}.
}
\details{
This function produces a summary list for objects of class 
\kbd{"OTC"} returned by \code{\link{OTC1}} or \code{\link{OTC2}}. 
It formats the optimal testing configuration, expected number of tests, 
expected number of tests per individual, and accuracy measures. 
A summary of the results from \code{\link{OTC1}} includes results for all 
objective functions specified by the user.

The \kbd{OTC} component of the result gives the optimal testing 
configuration, which may include the group sizes for each stage of a 
hierarchical testing algorithm or the row/column size and array size for an 
array testing algorithm. The \kbd{Tests} component of the result gives the 
expected number of tests and the expected number of tests per individual 
for the algorithm. 

The \kbd{Accuracy} component gives the overall accuracy measures for the 
algorithm. Accuracy measures included are the pooling sensitivity, pooling 
specificity, pooling positive predictive value, and pooling negative 
predictive value. These values are weighted averages of the corresponding 
individual accuracy measures for all individuals in the algorithm. 
Expressions for these averages are provided in the Supplementary Material 
for Hitt et al. (2019). For more information, see the 'Details' section for 
the \code{\link{OTC1}} or \code{\link{OTC2}} function.
}
\examples{
# Estimated running time for all examples was calculated 
#   using a computer with 16 GB of RAM and one core of 
#   an Intel i7-6500U processor. Please take this into 
#   account when interpreting the run time given.

# Find the optimal testing configuration for 
#   non-informative two-stage hierarchical testing.
res1 <- OTC1(algorithm="D2", p=0.01, Se=0.99, Sp=0.99, 
             group.sz=3:100, obj.fn=c("ET", "MAR", "GR1"), 
             weights=matrix(data=c(1,1), nrow=1, ncol=2))
summary(res1)

# Find the optimal testing configuration for 
#   informative three-stage hierarchical testing
res2 <- OTC1(algorithm="ID3", p=0.025, 
             Se=c(0.95, 0.95, 0.99), Sp=c(0.96, 0.96, 0.98), 
             group.sz=3:15, obj.fn=c("ET", "MAR"), alpha=2)
summary(res2)

# Find the optimal testing configuration for 
#   informative array testing without master pooling.
# This example takes approximately 30 seconds to run.
\donttest{
res3 <- OTC1(algorithm="IA2", p=0.05, alpha=2, 
             Se=0.90, Sp=0.90, group.sz=3:20, obj.fn="ET")
summary(res3)}

# Find the optimal testing configuraiton for 
#   informative two-stage hierarchical testing.
Se <- matrix(data=c(rep(0.95, 2), rep(0.99, 2)), 
             nrow=2, ncol=2, byrow=FALSE)
Sp <- matrix(data=c(rep(0.96, 2), rep(0.98, 2)), 
             nrow=2, ncol=2, byrow=FALSE)
res4 <- OTC2(algorithm="ID2", alpha=c(18.25, 0.75, 0.75, 0.25), 
                Se=Se, Sp=Sp, group.sz=12)
summary(res4)

# Find the optimal testing configuration for 
#   non-informative three-stage hierarchical testing.
# This example takes approximately 3 minutes to run.
Se <- matrix(data=c(rep(0.95, 6)), nrow=2, ncol=3)
Sp <- matrix(data=c(rep(0.99, 6)), nrow=2, ncol=3)
\donttest{
res5 <- OTC2(algorithm="D3", p.vec=c(0.95, 0.0275, 0.0175, 0.005), 
                Se=Se, Sp=Sp, group.sz=5:10)
summary(res5)}

# Find the optimal testing configuration for
#   non-informative array testing with master pooling.
# This example takes approximately 10 seconds to run.
\donttest{
res6 <- OTC2(algorithm="A2M", p.vec=c(0.90, 0.04, 0.04, 0.02), 
             Se=rep(0.99, 2), Sp=rep(0.99, 2), group.sz=3:15)
summary(res6)}
}
\seealso{
\code{\link{OTC1}} and \code{\link{OTC2}} 
for creating an object of class \kbd{"OTC"}.
}
\author{
Brianna D. Hitt
}
