% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bikm1_LBM_Poisson_functions.R
\name{PoissonBlocBIC}
\alias{PoissonBlocBIC}
\title{PoissonBlocBIC function for the computation of the BIC criterion in the Poisson LBM}
\usage{
PoissonBlocBIC(a,alpha,beta,v1,w1,x,res,normalization)
}
\arguments{
\item{a}{hyperparameter used in the VBayes algorithm for priors on the mixing proportions. By default, a=4.}

\item{alpha}{hyperparameter used in the VBayes algorithm for prior on the Poisson parameter. By default, alpha=1.}

\item{beta}{hyperparameter used in the VBayes algorithm for prior on the Poisson parameter. By default, beta=0.01.}

\item{v1}{a numeric vector of row partitions}

\item{w1}{a numeric vector of column partitions}

\item{x}{contingency matrix of observations.}

\item{res}{a BIKM1_LBM_Poisson object
\code{rho_h} mixing row proportions
\code{tau_l} mixing column proportions
\code{gamma_hl} Bernoulli parameters}

\item{normalization}{logical. To use the normalized Poisson modelling in the Latent Block Model. By default normalization=FALSE.}
}
\value{
a value of the BIC criterion
}
\description{
Produce a value of the BIC criterion for co-clustering partitions
}
\examples{
\donttest{require(bikm1)
J=200
K=120
h=3
l=2
theta=list()
theta$rho_h=1/h*matrix(1,h,1)
theta$tau_l=1/l*matrix(1,l,1)
theta$gamma_hl=matrix(c(1, 6,4, 1, 7, 1),ncol=2)
data=PoissonBlocRnd(J,K,theta)
res=BIKM1_LBM_Poisson(data$x,3,3,4,init_choice='smallVBayes')
bic=PoissonBlocBIC(v1=res@model_max$v,w1=res@model_max$w,x=data$x,res=res,normalization=TRUE)}
}
