% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlier-dist.R
\name{to_maha}
\alias{to_maha}
\title{Transform matrix}
\usage{
to_maha(U)
}
\arguments{
\item{U}{A matrix (e.g. PC scores).}
}
\value{
\code{U}, transformed.
}
\description{
Transform matrix to use Mahalanobis distance instead of Euclidean one.
}
\examples{
X <- readRDS(system.file("testdata", "three-pops.rds", package = "bigutilsr"))
svd <- svds(scale(X), k = 5)

U <- svd$u
dist1 <- covRob(U, estim = "pairwiseGK")$dist

U.maha <- to_maha(U)
dist2 <- rowSums(U.maha^2)
all.equal(dist2, dist1)

# to apply the same transformation to other data
attr(U.maha, "trans")

}
