% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ldsc.R
\name{coef_to_liab}
\alias{coef_to_liab}
\title{Liability scale}
\usage{
coef_to_liab(K_pop, K_gwas = 0.5)
}
\arguments{
\item{K_pop}{Prevalence in the population.}

\item{K_gwas}{Prevalence in the GWAS. You should provide this if you used
(\code{n_case + n_control}) as sample size. If using the effective sample size
\code{4 / (1 / n_case + 1 / n_control)} instead, you should keep the default
value of \code{K_gwas = 0.5} as the GWAS case-control ascertainment is already
accounted for in the effective sample size.}
}
\value{
Scaling coefficient to convert e.g. heritability to the liability scale.
}
\description{
Coefficient to convert to the liability scale. E.g. h2_liab = coef * h2_obs.
}
\examples{
h2 <- 0.2
h2 * coef_to_liab(0.02)
}
