% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigalgebra.R
\name{dpotrf}
\alias{dpotrf}
\title{Cholesky factorization}
\usage{
dpotrf(UPLO = "U", N = NULL, A, LDA = NULL)
}
\arguments{
\item{UPLO}{a character. 
\describe{
  \item{'U':}{ Upper triangle of A is stored;}
  \item{'L':}{ Lower triangle of A is stored.}
}}

\item{N}{an integer. The order of the matrix A.  N >= 0.}

\item{A}{a big.matrix, dimension (LDA,N).}

\item{LDA}{an integer. Dimension of the array A.  LDA >= max(1,N).}
}
\value{
updates the big matrix A with the result, INFO is an integer 
\describe{
  \item{= 0:}{ successful exit}
  \item{< 0:}{ if INFO = -i, the i-th argument had an illegal value}
  \item{> 0:}{ if INFO = i, the leading minor of order i is not positive definite, and the factorization could not be completed.}
}
Terms laying out of the computed triangle should be discarded.
}
\description{
DPOTRF computes the Cholesky factorization of a real symmetric positive definite matrix A.

The factorization has the form
\describe{
  \item{A =}{ U**T * U,  if UPLO = 'U', or}
  \item{A =}{ L  * L**T,  if UPLO = 'L',}
}
where U is an upper triangular matrix and L is lower triangular.

This is the block version of the algorithm, calling Level 3 BLAS.
}
\examples{
set.seed(4669)
A = matrix(rnorm(16),4)
B = as.big.matrix(A \%*\% t(A))
C = A \%*\% t(A)
chol(C)
dpotrf(UPLO='U', N=4, A=B, LDA=4)
D <- B[,]
D[lower.tri(D)]<-0
D
D-chol(C)
t(D)\%*\%D-C

#' # The big.matrix file backings will be deleted when garbage collected.
rm(A,B,C,D)
gc()
}
