% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigalgebra.R
\name{dgeev}
\alias{dgeev}
\title{DGEEV computes eigenvalues and eigenvectors.}
\usage{
dgeev(
  JOBVL = "V",
  JOBVR = "V",
  N = NULL,
  A,
  LDA = NULL,
  WR,
  WI,
  VL,
  LDVL = NULL,
  VR = NULL,
  LDVR = NULL,
  WORK = NULL,
  LWORK = NULL
)
}
\arguments{
\item{JOBVL}{a character.
\describe{
  \item{}{= 'N': left eigenvectors of A are not computed;}
  \item{}{= 'V': left eigenvectors of A are computed.}
}}

\item{JOBVR}{a character.
\describe{
  \item{}{= 'N': right eigenvectors of A are not computed;}
  \item{}{= 'V': right eigenvectors of A are computed.}
}}

\item{N}{an integer. The order of the matrix A. N >= 0.}

\item{A}{a matrix of dimension (LDA,N), the N-by-N matrix A.}

\item{LDA}{an integer. The leading dimension of the matrix A. LDA >= max(1,N).}

\item{WR}{a vector of dimension (N). WR contain the real part of the computed eigenvalues. Complex conjugate pairs of eigenvalues appear consecutively with the eigenvalue having the positive imaginary part first.}

\item{WI}{a vector of dimension (N). WI contain the imaginary part of the computed eigenvalues. Complex conjugate pairs of eigenvalues appear consecutively with the eigenvalue having the positive imaginary part first.}

\item{VL}{a matrx of dimension (LDVL,N)
\describe{
  \item{}{If JOBVL = 'V', the left eigenvectors u(j) are stored one
  after another in the columns of VL, in the same order
  as their eigenvalues.}
  \item{}{If JOBVL = 'N', VL is not referenced.}
  \item{}{If the j-th eigenvalue is real, then u(j) = VL(:,j),
  the j-th column of VL.}
  \item{}{If the j-th and (j+1)-st eigenvalues form a complex
  conjugate pair, then u(j) = VL(:,j) + i*VL(:,j+1) and
  u(j+1) = VL(:,j) - i*VL(:,j+1).}
}}

\item{LDVL}{an integer. The leading dimension of the array VL. LDVL >= 1; if JOBVL = 'V', LDVL >= N.}

\item{VR}{a matrix of dimension (LDVR,N). 
\describe{
  \item{}{If JOBVR = 'V', the right eigenvectors v(j) are stored one after another in the columns of VR, in the same order as their eigenvalues.}
  \item{}{If JOBVR = 'N', VR is not referenced.}
  \item{}{If the j-th eigenvalue is real, then v(j) = VR(:,j), the j-th column of VR.}
  \item{}{If the j-th and (j+1)-st eigenvalues form a complex conjugate pair, then v(j) = VR(:,j) + i*VR(:,j+1) and v(j+1) = VR(:,j) - i*VR(:,j+1).}
 }}

\item{LDVR}{an integer. The leading dimension of the array VR.  LDVR >= 1; if JOBVR = 'V', LDVR >= N.}

\item{WORK}{a matrix of dimension (MAX(1,LWORK))}

\item{LWORK}{an integer. The dimension of the array WORK.LWORK >= max(1,3*N), and if JOBVL = 'V' or JOBVR = 'V', LWORK >= 4*N. For good performance, LWORK must generally be larger. If LWORK = -1, then a workspace query is assumed; the routine only calculates the optimal size of the WORK array, returns this value as the first entry of the WORK array, and no error message related to LWORK is issued by XERBLA.}
}
\value{
WR, WI, VR, VL and Work. On exit, A has been overwritten.
}
\description{
DGEEV computes the eigenvalues and, optionally, the left and/or right eigenvectors for GE matrices.

DGEEV computes for an N-by-N real nonsymmetric matrix A, the eigenvalues and, optionally, the left and/or right eigenvectors.
The right eigenvector v(j) of A satisfies A * v(j) = lambda(j) * v(j) where lambda(j) is its eigenvalue.
The left eigenvector u(j) of A satisfies u(j)**H * A = lambda(j) * u(j)**H where u(j)**H denotes the conjugate-transpose of u(j).

The computed eigenvectors are normalized to have Euclidean norm equal to 1 and largest component real.
}
\examples{
\donttest{
set.seed(4669)
A = matrix(rnorm(16),4)
WR= matrix(0,nrow=4,ncol=1)
WI= matrix(0,nrow=4,ncol=1)
VL = matrix(0,ncol=4,nrow=4)
eigen(A)
dgeev(A=A,WR=WR,WI=WI,VL=VL)
VL
WR
WI

rm(A,WR,WI,VL)

A = as.big.matrix(matrix(rnorm(16),4))
WR= matrix(0,nrow=4,ncol=1)
WI= matrix(0,nrow=4,ncol=1)
VL = as.big.matrix(matrix(0,ncol=4,nrow=4))
eigen(A[,])
dgeev(A=A,WR=WR,WI=WI,VL=VL)
VL[,]
WR[,]
WI[,]

rm(A,WR,WI,VL)
gc()
}
}
