% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdm_plot.R
\name{bdm.ptsne.plot}
\alias{bdm.ptsne.plot}
\title{Plot ptSNE (low-dimensional embedding)}
\usage{
bdm.ptsne.plot(bdm, ptsne.cex = 0.5, ptsne.bg = "#FFFFFF",
  class.pltt = NULL, layer = 1)
}
\arguments{
\item{bdm}{A \var{bdm} instance as generated by \code{bdm.init()} or a list of them to make a comparative plot.}

\item{ptsne.cex}{The size of the mapped data-points in the ptSNE plot. Default value is \code{ptsne.cex = 0.5}.}

\item{ptsne.bg}{The background colour of the ptSNE plot. Default value is \code{ptsne.bg = #FFFFFF} (white).}

\item{class.pltt}{A colour palette to show class labels in the ptSNE plot. If \code{!is.null(bdm$wtt)} cluster labels are used by default, else if \code{!is.null(bdm$lbls)} are used by default. If \code{ptsne.pltt = NULL} (default value) the default palette is used.}

\item{layer}{The \var{bdm$ptsne} layer to be used (default value is \code{layer = 1}).}
}
\value{
None.
}
\description{
Plot ptSNE (low-dimensional embedding)
}
\examples{

bdm.example()
exMap <- bdm.ptsne.plot(exMap)
}
