% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdm_dMap.R
\name{bdm.dMap}
\alias{bdm.dMap}
\title{Class density maps}
\usage{
bdm.dMap(bdm, threads = 2, type = "SOCK", labels = NULL, layer = 1)
}
\arguments{
\item{bdm}{A \var{bdm} instance as generated by \code{bdm.init()}.}

\item{threads}{The number of parallel threads (in principle only limited by hardware resources, \code{i.e.} number of cores and available memory)}

\item{type}{The type of cluster: 'SOCK' (default) for intra-node parallelization, 'MPI' for inter-node parallelization (\code{message passing interface} parallel environment).}

\item{labels}{A vector of point-wise covariate values or class labels. The covariate values can be of any factorizable type. By default (\code{labels=NULL}) the function computes the density maps based on the clustering labels (i.e. equivalent to \code{labels=bdm.labels(bdm)})}

\item{layer}{The number of the t-SNE layer (1 by default).}
}
\value{
A copy of the input \var{bdm} instance with element \var{$dMap}, a matrix with a soft clustering of the grid cells.
}
\description{
Compute the class density maps of a set of classes on the embedding grid. This function returns a fuzzy mapping of the set of classes on the grid cells.  The classes can be whatever set of classes of interest and must be given as a vector of point-wise discrete labels (either numeric, string or factor).
}
\details{
\code{bdm.dMap()} computes the join distribution \eqn{P(V=v_{i},C=c_{j})} where \eqn{V={v_{1},\dots,v_{l}}} is the discrete covariate and \eqn{C={c_{1},\dots, c_{g}}} are the grid cells of the paKDE raster. That is, this function recomputes the paKDE but keeping track of the covariate (or class) label of each data-point. This results in a fuzzy distribution of the covariate (class) at each cell.

Usually, figuring out the join distribution \eqn{P(V=v_{i},C=c_{j})} entails an intensive computation. Thus \code{bdm.dMap()} performs the computation and stores the result in a dedicated element named \var{$dMap}. Afterwards the class density maps can be visualized with the \code{bdm.dMap.plot()} function.
}
\examples{

# --- load example dataset
bdm.example()
\dontrun{
exMap <- bdm.dMap(exMap, threads = 4)
}
}
