% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/settings.R
\name{bfw}
\alias{bfw}
\title{Settings}
\usage{
bfw(
  job.title = NULL,
  job.group = NULL,
  jags.model,
  jags.seed = NULL,
  jags.method = NULL,
  jags.chains = NULL,
  custom.function = NULL,
  custom.model = NULL,
  params = NULL,
  saved.steps = 10000,
  thinned.steps = 1,
  adapt.steps = NULL,
  burnin.steps = NULL,
  initial.list = list(),
  custom.name = NULL,
  project.name = "Project",
  project.dir = "Results/",
  project.data = NULL,
  time.stamp = TRUE,
  save.data = FALSE,
  data.set = "AllData",
  data.format = "csv",
  raw.data = FALSE,
  run.robust = FALSE,
  merge.MCMC = FALSE,
  run.diag = FALSE,
  sep = ",",
  silent = FALSE,
  ...
)
}
\arguments{
\item{job.title}{title of analysis, Default: NULL}

\item{job.group}{for some hierarchical models with several layers of parameter names (e.g., latent and observed parameters), Default: NULL}

\item{jags.model}{specify which module to use}

\item{jags.seed}{specify seed to replicate a analysis, Default: NULL}

\item{jags.method}{specify method for JAGS (e.g., parallel or simple), Default: NULL}

\item{jags.chains}{specify specify number of chains for JAGS, Default: NULL}

\item{custom.function}{custom function to use (e.g., defined function, external R file or string with function), Default: NULL}

\item{custom.model}{define a custom model to use (e.g., string or text file (.txt), Default: NULL}

\item{params}{define parameters to observe, Default: NULL}

\item{saved.steps}{define the number of iterations/steps/chains in the MCMC simulations, Default: 10000}

\item{thinned.steps}{save every kth step of the original saved.steps, Default: 1}

\item{adapt.steps}{the number of adaptive iterations to use at the start of each simulation, Default: NULL}

\item{burnin.steps}{the number of burnin iterations, NOT including the adaptive iterations to use for the simulation, Default: NULL}

\item{initial.list}{initial values for analysis, Default: list()}

\item{custom.name}{custom name of project, Default: NULL}

\item{project.name}{name of project, Default: 'Project'}

\item{project.dir}{define where to save data, Default: 'Results/'}

\item{project.data}{define data to use for analysis (e.g., csv, rda, custom data.frame or matrix, or data included in package, Default: NULL}

\item{time.stamp}{logical, indicating whether or not to append unix time stamp to file name, Default: TRUE}

\item{save.data}{logical, indicating whether or not to save data, Default: FALSE}

\item{data.set}{define subset of data, Default: 'AllData'}

\item{data.format}{define what data format is being used, Default: 'csv'}

\item{raw.data}{logical, indicating whether or not to use unprocessed data, Default: FALSE}

\item{run.robust}{logical, indicating whether or not robust analysis, Default: FALSE}

\item{merge.MCMC}{logical, indicating whether or not to merge MCMC chains, Default: FALSE}

\item{run.diag}{logical, indicating whether or not to run diagnostics, Default: FALSE}

\item{sep}{symbol to separate data (e.g., comma-delimited), Default: ','}

\item{silent}{logical, indicating whether or not to run analysis without output, Default: FALSE}

\item{...}{further arguments passed to or from other methods}
}
\value{
data from MCMC \link[bfw]{RunMCMC}
}
\description{
main settings for bfw
}
\details{
Settings act like the main framework for bfw, connecting function, model and JAGS.
}
\seealso{
\code{\link[utils]{head}},\code{\link[utils]{modifyList}},\code{\link[utils]{capture.output}}
}
