% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ntbf01.R
\name{ntbf01}
\alias{ntbf01}
\title{Sample size calculations for \eqn{t}-test Bayes factor}
\usage{
ntbf01(
  k,
  power,
  null = 0,
  plocation = 0,
  pscale = 1/sqrt(2),
  pdf = 1,
  type = c("two.sample", "one.sample", "paired"),
  alternative = c("two.sided", "less", "greater"),
  dpm = plocation,
  dpsd = pscale,
  lower.tail = TRUE,
  integer = TRUE,
  nrange = c(2, 10^4),
  ...
)
}
\arguments{
\item{k}{Bayes factor threshold}

\item{power}{Target power}

\item{null}{Standardized mean difference under the point null hypothesis.
Defaults to \code{0}}

\item{plocation}{\eqn{t} prior location. Defaults to \code{0}}

\item{pscale}{\eqn{t} prior scale. Defaults to \code{1/sqrt(2)}}

\item{pdf}{\eqn{t} prior degrees of freedom. Defaults to \code{1} (a Cauchy
prior)}

\item{type}{Type of \eqn{t}-test. Can be \code{"two.sample"} (default),
\code{"one.sample"}, or \code{"paired"}}

\item{alternative}{Direction of the test. Can be either \code{"two.sided"}
(default), \code{"less"}, or \code{"greater"}. The latter two truncate
the analysis prior to negative and positive effects, respectively. If set
to \code{"less"} or \code{"greater"}, the power is only computed based on
data with effect estimates in the direction of the alternative}

\item{dpm}{Mean of the normal design prior assigned to the standardized mean
difference. Defaults to the analysis prior location}

\item{dpsd}{Standard deviation of the normal design prior assigned to the
standardized mean difference. Set to \code{0} to obtain a point prior at
the design prior mean. Defaults to the analysis prior scale}

\item{lower.tail}{Logical indicating whether Pr(BF \eqn{\leq} \code{k})
(\code{TRUE}) or Pr(BF \eqn{>} \code{k}) (\code{FALSE}) should be
computed. Defaults to \code{TRUE}}

\item{integer}{Logical indicating whether only integer valued sample sizes
should be returned. If \code{TRUE} the required sample size is rounded to
the next larger integer. Defaults to \code{TRUE}}

\item{nrange}{Sample size search range over which numerical search is
performed. Defaults to \code{c(2, 10^4)}}

\item{...}{Other arguments passed to \code{stats::uniroot}}
}
\value{
The required sample size to achieve the specified power
}
\description{
This function computes the required sample size to obtain a
    \eqn{t}-test Bayes factor (\link{tbf01}) more extreme than a threshold
    \code{k} with a specified target power.
}
\examples{
 ## example from Schönbrodt and Wagenmakers (2018, p.135)
 ntbf01(k = 1/6, power = 0.95, dpm = 0.5, dpsd = 0, alternative = "greater")
 ntbf01(k = 1/6, power = 0.95, dpm = 0.5, dpsd = 0.1, alternative = "greater")
 ntbf01(k = 6, power = 0.95, dpm = 0, dpsd = 0, alternative = "greater",
        lower.tail = FALSE, nrange = c(2, 10000))

}
\seealso{
\link{ptbf01}, \link{powertbf01}, \link{tbf01}
}
\author{
Samuel Pawel
}
