% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaSandwich-beta-hc.R
\name{BetaHC}
\alias{BetaHC}
\title{Estimate Standardized Regression Coefficients and Robust Sampling Covariance Matrix}
\usage{
BetaHC(object, type = "hc3", g1 = 1, g2 = 1.5, k = 0.7)
}
\arguments{
\item{object}{Object of class \code{lm}.}

\item{type}{Character string.
Correction type.
Possible values are
\code{"hc0"},
\code{"hc1"},
\code{"hc2"},
\code{"hc3"},
\code{"hc4"},
\code{"hc4m"}, and
\code{"hc5"}.}

\item{g1}{Numeric.
\code{g1} value for \code{type = "hc4m"} or \code{type = "hc5"}.}

\item{g2}{Numeric.
\code{g2} value for \code{type = "hc4m"}.}

\item{k}{Numeric.
Constant for \code{type = "hc5"}}
}
\value{
Returns an object of class \code{betaSandwich} which is a list with the following elements:
\describe{
\item{call}{Function call.}
\item{type}{Standard error type.}
\item{beta}{Vector of standardized slopes.}
\item{vcov}{Sampling covariance matrix of the standardized slopes.}
\item{n}{Sample size.}
\item{p}{Number of regressors.}
\item{df}{\eqn{n - p - 1} degrees of freedom}
}
}
\description{
Estimate Standardized Regression Coefficients and Robust Sampling Covariance Matrix
}
\examples{
object <- lm(QUALITY ~ NARTIC + PCTGRT + PCTSUPP, data = nas1982)
std <- BetaHC(object)
# Methods -------------------------------------------------------
print(std)
summary(std)
coef(std)
vcov(std)
confint(std, level = 0.95)
}
\references{
Dudgeon, P. (2017).
Some improvements in confidence intervals for standardized regression coefficients.
\emph{Psychometrika}, \emph{82}(4), 928–951.
\doi{10.1007/s11336-017-9563-z}
}
\seealso{
Other Beta Sandwich Functions: 
\code{\link{BetaN}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Beta Sandwich Functions}
\keyword{betaSandwich}
