% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.tab.R
\name{write.tab}
\alias{write.tab}
\title{write table with different defaults}
\usage{
write.tab(
  x,
  file = NULL,
  sep = "\\t",
  name_rn = NULL,
  row.names = FALSE,
  col.names = !is.null(colnames(x)),
  quote = FALSE,
  fileEncoding = "UTF-8",
  open = TRUE,
  ...
)
}
\arguments{
\item{x}{Objekt to be written.}

\item{file}{Filename. DEFAULT: NULL = [name of x].txt}

\item{sep}{Column separator. DEFAULT: "\\t"}

\item{name_rn}{If not NULL, this will be used as the name for a prepended
column with the rownames. DEFAULT: NULL}

\item{row.names}{Should rownames be written in a pre-column that will
mess up alignment with column names? 
Use \code{name_rn} instead. DEFAULT: FALSE}

\item{col.names}{Should colnames be written? 
DEFAULT: TRUE if x has colnames}

\item{quote}{Write quatation marks around charstrings? DEFAULT: FALSE}

\item{fileEncoding}{Encoding of charstrings. DEFAULT: "UTF-8"}

\item{open}{Try to open the output file? DEFAULT: TRUE}

\item{\dots}{Further arguments passed to \code{\link{write.table}}}
}
\value{
full filename
}
\description{
calls write.table with (personally) useful default values for the arguments.
if \code{open=TRUE}, tries to open the file in the default txt viewer.
}
\examples{
# Don't run on CRAN test machines:
\dontrun{
write.tab(iris)
write.tab(iris, "otherfile.txt")
write.tab(freeny)
write.tab(freeny, name_rn="Time")
unlink("iris.txt")
unlink("otherfile.txt")
unlink("freeny.txt")
}
}
\seealso{
\code{\link{write.tab}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Sep 2021
}
\keyword{file}
