% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logHist.R
\name{logHist}
\alias{logHist}
\title{Histogram of logarithmic values}
\usage{
logHist(x, logargs = NULL, main = xmain, xlab = xname, col = "tan",
  add = FALSE, las = 1, ylim = NULL, freq = TRUE, quiet = FALSE, ...)
}
\arguments{
\item{x}{Vector of numerical values}

\item{logargs}{A list of arguments passed to \code{\link{logAxis}}. DEFAULT: NULL}

\item{main}{Title of graph, internally from x. DEFAULT: internal name representation}

\item{xlab}{X axis label. DEFAULT: internal: name of x}

\item{col}{Color of histogram bars}

\item{add}{Logical: add to existing plot?}

\item{las}{Integer: label axis style. DEFAULT: 1 (numbers upright)}

\item{ylim}{2 Numbers: y-axis range. DEFAULT: NULL}

\item{freq}{Logical: counts instead of density? DEFAULT: TRUE}

\item{quiet}{Logical: suppress warning about non-positive values? DEFAULT: FALSE}

\item{\dots}{further arguments passed to \code{\link{hist}}
like breaks, xlim=c(-1,3), ..., but not xaxt}
}
\value{
none
}
\description{
Draw histogram of values on a logarithmic scale with nice axis labels
}
\examples{

dat <- rbeta(1e4, 2, 18)*100
hist(dat, col="tan", breaks=50)
logHist(dat)
logHist(dat, freq=FALSE)
logHist(dat, breaks=50)
logHist(dat,xlim=c(0,2)) # xlim in powers of ten
logHist(c(-1,0,1,2,2,3,3,4,8,10,50)) # warning for negative values

}
\seealso{
\code{\link{logAxis}}, \code{\link{hist}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Feb 2016
}
\keyword{aplot}
\keyword{dplot}
