% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newFilename.R
\name{newFilename}
\alias{newFilename}
\title{Create new filename if file already exists}
\usage{
newFilename(filename, ignore = FALSE, pre = "", mid = "\\n  ", end = "",
  quiet = FALSE, ntrunc = 3)
}
\arguments{
\item{filename}{Char (vector): file name(s).}

\item{ignore}{Logical (vector, recycled): Ignore file? DEFAULT: FALSE}

\item{pre, mid, end}{Char: strings to append after traceback / message / filenames. 
DEFAULT: "", "\\n  ", ""}

\item{quiet}{Logical: Suppress messages about creating file(s)? DEFAULT: FALSE}

\item{ntrunc}{Integer: Number of filenames printed in messages before they
get truncated with message "(and xx more)". DEFAULT: 3}
}
\value{
newFilename returns the input with an added "_n" in the filename
        for each file that already existed.
}
\description{
Check if files already exist and append \code{_1} or \code{_2}, etc to the filename if needed,
thereby giving useful messages.
}
\examples{

fns <- c("data", "stupiddummy", "ExampleGraph.png", "berryFunctions.Rproj", 
         "README.md", "stupiddummy.txtdude", "DESCRIPTION", "test_devel.R")
newFilename(fns)
newFilename(fns, ignore=TRUE)
newFilename(fns, ignore=rep(0:1, each=4))
newFilename(fns, ntrunc=2)
newFilename("README.md")
newFilename("dummy", mid="") # no line break

}
\seealso{
\code{\link{file.exists}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Oct 2016 + Jan 2017
}
\keyword{file}
