% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traceCall.R
\name{traceCall}
\alias{traceCall}
\title{call stack of a function}
\usage{
traceCall(skip = 0)
}
\arguments{
\item{skip}{Number of levels to skip in \code{\link{traceback}}}
}
\value{
Character string with the call stack
}
\description{
trace the call stack e.g. for error checking and format output for do.call levels
}
\section{Warning}{
 In \link{do.call} settings with large objects,
                  tracing may take a lot of computing time.
}
\examples{
lower <- function(a, s) warning(traceCall(s), "final value is: ", a+10)
upper <- function(b, skip=0) lower(b+5, skip)
upper(3)
upper(3, skip=1) # traceCall skips last level (warning)
upper(3, skip=4) # now the stack is empty
upper(3, skip=-1) # get one more level down
is.error(upper("four"))

}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Sep 2016
}
\seealso{
\code{\link{checkFile}} for example usage
}
\keyword{error}
\keyword{programming}

