% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getName.R
\name{getName}
\alias{getName}
\title{get the name of an input in nested function calls}
\usage{
getName(x)
}
\arguments{
\item{x}{input object name or character string}
}
\value{
Character string with the name
}
\description{
get the name of an input in nested function calls
}
\examples{
# This does not work well:

lower <- function(x) deparse(substitute(x))
upper <- function(y) lower(y)
lower(pi) # returns "pi", as expected
upper(pi) # returns "y".

# That's why there is getName:

getName(pi) # returns "pi", as expected
upper <- function(y) getName(y)
upper(pi) # yay!

upper("dummy")
upper(dummy) # works also for nonexistent objects
dummy <- 7
upper("dummy") # still stable
upper(dummy) # still stable

}
\author{
\url{http://stackoverflow.com/users/2725969/brodieg}
        Implementation Berry Boessenkool, \email{berry-b@gmx.de}, Sep 2016
}
\seealso{
\url{http://stackoverflow.com/a/26558733}, \code{\link{substitute}}
}
\keyword{IO}
\keyword{character}

