% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{read_iti}
\alias{read_iti}
\alias{validate_iti}
\title{Read and Validate Infaunal Trophic Index Files}
\usage{
read_iti(filename)

validate_iti(.data)
}
\arguments{
\item{filename}{name of the ITI file (character).}

\item{.data}{table in ITI-format}
}
\value{
A data frame with columns \code{TAXON} containing taxa and 
     \code{GROUP} containing user-defined ITI-groups
      (see Gittenberger & Van Loon, 2013).
}
\description{
This function reads and checks files containing Infaunal Trophic Index 
(ITI) data (Gittenberger & Van Loon, 2013)
}
\details{
The function performs the following tasks:
\itemize{
		\item{checks the existence of \code{filename};}
 	\item{checks availablitity of required columns (case insensitive), 
         i.e., TAXON and GROUP;}
 	\item{removes redundant spaces;}
 	\item{removes duplicated records.}
     \item{checks if all ITI classes are I, II, III, or IV}
}
The column 'GROUP' contains the Roman numerals I, II, III, and IV, with
the following meaning:
\itemize{
    	\item{  I: } {suspension feeders;}
 	\item{ II: } {interface feeders;}
 	\item{III: } {surface deposit feeders;}
     \item{ IV: } {subsurface deposit feeders.}
}
}
\section{Functions}{
\itemize{
\item \code{validate_iti}: validator for ITI-format
}}

\references{
Gittenberger A. and  W. van Loon, 2013. 
     Sensitivities of marine macrozoobenthos to environmental pressures 
     in the Netherlands. Nederlandse Faunistische 
     Mededelingen 41: 79-112.
}
