% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{read_beqi2}
\alias{read_beqi2}
\alias{validate_beqi2}
\title{Read and Validate BEQI2 Input Files}
\usage{
read_beqi2(filename)

validate_beqi2(.data)
}
\arguments{
\item{filename}{name of BEQI2 input file (\code{character})}

\item{.data}{table in BEQI2-format}
}
\description{
This function reads and checks BEQI2 input files. The format has been
specified in Van Loon (2013) and is described in the vignette of the BENMMI-package.
}
\details{
The function performs the following tasks:
\itemize{
     \item{checks the existence of \code{filename};}
 	\item{checks availablitity of required columns (case insensitive);}
     \item{make column names with aggregation data case-insensitive;}
 	\item{removes redundant spaces;}
     \item{checks if DATE-field adheres to ISO 8601 (YYYY-mm-dd);}
 	\item{constructs a unique identifier \code{ID} by concatenating 
         columns \code{OBJECTID} and \code{DATE};}
     \item{checks that each \code{ID} has a unique \code{AREA};}
     \item{checks azoic samples for VALUE=0;}
     \item{removes records with VALUE=0, not belonging to azoic samples;}
     \item{checks VALUE-field on missing values;}
     \item{checks if VALUE-field is an integer;}
 }
}
\section{Functions}{
\itemize{
\item \code{validate_beqi2}: validator for BEQI2-format
}}

\references{
Willem van Loon, 2013. BEQI2 INPUT FORMAT. See the package-vignette of the BENMMI-package.
}
