% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean.R
\name{mean.benchmark}
\alias{mean.benchmark}
\title{Mean method for the \code{benchmark} timings.}
\usage{
\method{mean}{benchmark}(x, trim = 0.05, conf.level = 0.95, relative = "mean", ...)
}
\arguments{
\item{x}{An object of class \code{benchmark}.}

\item{trim}{Numeric. The fraction (0 to 0.5) of observations to be trimmed
before the mean is computed.}

\item{conf.level}{Numeric. Confidence level of the interval.}

\item{relative}{Character. The name or index of the column whose values
will be used to compute relative timings.}

\item{\dots}{Not currently used.}
}
\value{
The method returns a \code{data.frame} with additional attributes,
which contains these columns:
\item{expr}{The deparsed expression as passed to
\code{benchmark} or the name of the argument if the expression was
passed as a named argument.}
\item{mean}{Sample mean for timing results.}
\item{trimmed}{Trimmed sample mean for timing results (a fraction of
observations to be trimmed is defined by the argument \code{trim}).}
\item{lw.ci}{Lower boundary for the confidence level (confidence level is
specified by the argument \code{conf.level}).}
\item{up.ci}{Upper boundary for the confidence level (confidence level is
specified by the argument \code{conf.level}).}
\item{relative}{Relative difference across expressions compared to a minimal
value in the column, specified by the argument \code{relative}.}

Additional attributes:
\item{units}{Units for time intervals.}
\item{conf.level}{Confidence level.}
\item{trim}{Fraction of observations that was trimmed before the trimmed
mean was computed.}
}
\description{
This method computes aggregated statistics (sample mean and confidence
intervals) for each expression.
}
\examples{
timings <- benchmark(
  rchisq(100, 0), rchisq(100, 1), rchisq(100, 2),
  rchisq(100, 3), rchisq(100, 5),
  times = 1000L
)
mean(timings)
}
\seealso{
\code{\link[=summary.benchmark]{summary.benchmark()}}
}
\author{
Artem Klevtsov \email{a.a.klevtsov@gmail.com}
}
