% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_site_model.R
\name{create_site_model}
\alias{create_site_model}
\title{General function to create a site model.}
\usage{
create_site_model(name, id, gamma_site_model = create_gamma_site_model(), ...)
}
\arguments{
\item{name}{the site model name. Valid
names can be found in \code{get_site_model_names}}

\item{id}{the IDs of the alignment (can be extracted from
the FASTA filename using \code{\link{get_alignment_id}})}

\item{gamma_site_model}{a gamma site model, as created
by \code{\link{create_gamma_site_model}}}

\item{...}{specific site model parameters}
}
\value{
a site_model
}
\description{
General function to create a site model.
}
\note{
Prefer using the
  named functions
  \code{\link{create_gtr_site_model}},
  \code{\link{create_hky_site_model}},,
  \code{\link{create_jc69_site_model}},
  and \code{\link{create_tn93_site_model}}
}
\examples{
if (is_on_ci()) {

  check_empty_beautier_folder()

  input_filename <- get_fasta_filename()
  gtr_site_model <- create_gtr_site_model()
  hk_site_model <- create_hky_site_model()
  jc69_site_model <- create_jc69_site_model()
  tn93_site_model <- create_tn93_site_model()

  # Can use any site model
  output_filename <- get_beautier_tempfilename()
  create_beast2_input_file(
    input_filename = input_filename,
    output_filename = output_filename,
    site_model = jc69_site_model
  )
  file.remove(output_filename)

  remove_beautier_folder()
  check_empty_beautier_folder()
}
}
\seealso{
See \code{\link{create_gtr_site_model}} for more examples
  with a GTR site model. See \code{\link{create_hky_site_model}}
  for more examples with an HKY site model. See
  \code{\link{create_jc69_site_model}} for more examples with a JC69
  site model. See \code{\link{create_tn93_site_model}} for more
  examples with a TN93 site model
}
\author{
Richèl J.C. Bilderbeek
}
