% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_rate_categories_state_node_xml.R
\name{create_rate_categories_state_node_xml}
\alias{create_rate_categories_state_node_xml}
\title{Internal function}
\usage{
create_rate_categories_state_node_xml(inference_model)
}
\arguments{
\item{inference_model}{a Bayesian phylogenetic inference model.
An inference model is the complete model setup in which a site model,
clock model, tree prior and more are specified.
Use \link{create_inference_model} to create an inference model.
Use \link{check_inference_model} to check if  an inference model is valid.
Use \link{rename_inference_model_filenames} to rename the files in an
inference model.}
}
\value{
the following XML:
\code{
  "<stateNode id=\"rateCategories.c:[id]\"
  spec=\"parameter.IntegerParameter\" dimension=\"[dimension]\">
  1
  </stateNode>"
}
}
\description{
Creates the \code{rateCategories} state node,
such as:
\code{
  "<stateNode id=\"rateCategories.c:[id]\"
    spec=\"parameter.IntegerParameter\"
    dimension=\"[dimension]\">
  1
  </stateNode>"
}
}
\examples{
check_empty_beautier_folder()

create_rate_categories_state_node_xml(
  create_inference_model(
    clock_model = create_rln_clock_model(
      id = 314,
      dimension = 1
    )
  )
)

check_empty_beautier_folder()
}
\author{
Richèl J.C. Bilderbeek
}
