% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_ucld_stdev_state_node_param_xml.R
\name{create_ucld_stdev_state_node_param_xml}
\alias{create_ucld_stdev_state_node_param_xml}
\title{Internal function}
\usage{
create_ucld_stdev_state_node_param_xml(inference_model)
}
\arguments{
\item{inference_model}{a Bayesian phylogenetic inference model.
An inference model is the complete model setup in which a site model,
clock model, tree prior and more are specified.
Use \link{create_inference_model} to create an inference model.
Use \link{check_inference_model} to check if  an inference model is valid.
Use \link{rename_inference_model_filenames} to rename the files in an
inference model.}
}
\value{
the following XML:
\code{
  <parameter id="ucldStdev.c:[id]" lower="0.0" name="stateNode">
    0.1
  </parameter>
}
}
\description{
Creates the \code{ucldStdev} parameter with the name \code{stateNode},
such as:
\code{
  <parameter id="ucldStdev.c:[id]" [...] name="stateNode">0.1</parameter>
}
}
\examples{
check_empty_beautier_folder()

create_ucld_stdev_state_node_param_xml(
  create_inference_model(
    clock_model = create_rln_clock_model(id = 314)
  )
)

check_empty_beautier_folder()
}
\author{
Richèl J.C. Bilderbeek
}
