% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_site_model.R
\name{check_site_model}
\alias{check_site_model}
\title{Check if the site model is a valid site model}
\usage{
check_site_model(site_model)
}
\arguments{
\item{site_model}{a site model,
as returned by \code{\link{create_site_model}}}
}
\value{
nothing
}
\description{
Calls \code{stop} if the site models are invalid
}
\examples{
check_empty_beautier_folder()

check_site_model(create_jc69_site_model())
check_site_model(create_hky_site_model())
check_site_model(create_tn93_site_model())
check_site_model(create_gtr_site_model())

# Can use list of one site model
check_site_model(list(create_jc69_site_model()))

check_empty_beautier_folder()
}
\seealso{
Use \link{create_site_model} to create a valid site model
}
\author{
Richèl J.C. Bilderbeek
}
