% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_beauti_options.R
\name{create_beauti_options}
\alias{create_beauti_options}
\title{Function to create a set of BEAUti options.}
\usage{
create_beauti_options(capitalize_first_char_id = FALSE,
  nucleotides_uppercase = FALSE, beast2_version = "2.4",
  required = "", sequence_indent = 20)
}
\arguments{
\item{capitalize_first_char_id}{must the ID of alignment start with a
capital? TRUE if yes, FALSE if it can be left lower case (if it is
lowercase)}

\item{nucleotides_uppercase}{must the nucleotides of the DNA sequence be
in uppercase?}

\item{beast2_version}{the BEAST2 version}

\item{required}{things that may be required,
for example \code{BEAST v2.5.0}}

\item{sequence_indent}{the number of spaces the XML \code{sequence}
lines are indented}
}
\value{
a BEAUti options structure
}
\description{
BEAUti options are settings that differ between BEAUti
version. The use of these options is mostly for testing
older versions
Whatever option chosen here, the created XML file will be valid.
}
\examples{
  beauti_options <- create_beauti_options(
    nucleotides_uppercase = TRUE,
    beast2_version = "2.5"
  )
  xml <- create_beast2_input(
    get_fasta_filename(),
    beauti_options = beauti_options
  )
  testit::assert(is.character(xml))
  testit::assert(length(xml) > 1)
}
\author{
Richèl J.C. Bilderbeek
}
