% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_beast2_version_cmd.R
\name{create_beast2_version_cmd}
\alias{create_beast2_version_cmd}
\title{Creates the terminal command to version a BEAST2 input file}
\usage{

  create_beast2_version_cmd(beast2_path = beastier::get_default_beast2_path())
}
\arguments{
\item{beast2_path}{name of either a BEAST2 binary file
(usually simply \code{beast})
or a BEAST2 jar file
(usually has a \code{.jar} extension).
Use \link{get_default_beast2_bin_path} to get
the default BEAST binary file's path
Use \link{get_default_beast2_jar_path} to get
the default BEAST jar file's path}
}
\value{
a character vector, of which the first element
  is the command (\code{java}, in this case),
  and the others are arguments (\code{-jar}, in this case, followed
  by more arguments.
}
\description{
Creates the terminal command to version a BEAST2 input file
}
\examples{
  if (is_beast2_installed() && is_on_ci()) {
    cmds <- create_beast2_version_cmd()
    testit::assert(cmds[2] == "-cp")
  }
}
\author{
Richèl J.C. Bilderbeek
}
