% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_default_beast2_path.R
\name{get_default_beast2_path}
\alias{get_default_beast2_path}
\title{Get the default BEAST2 path}
\usage{
get_default_beast2_path()
}
\value{
the default BEAST2 path
}
\description{
Get the default BEAST2 path
}
\examples{
  library(testthat)

  if (is_beast2_installed()) {
    def_path <- get_default_beast2_path()
    bin_path <- get_default_beast2_bin_path()
    jar_path <- get_default_beast2_jar_path()
    expect_true(def_path == bin_path || def_path == jar_path)
  }
}
\seealso{
Use \link{get_default_beast2_bin_path}
    to get the default path to the BEAST2 binary file.
  Use \link{get_default_beast2_jar_path}
    to get the default path to the BEAST2 jar file.
  Use \link{get_default_beast2_folder} to get the default
  folder in which BEAST2 is installed.
  Use \link{install_beast2} with default arguments
  to install BEAST2 to this location.
}
\author{
Richèl J.C. Bilderbeek
}
