% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_default_trees_filename.R
\name{create_default_trees_filenames}
\alias{create_default_trees_filenames}
\title{Create the default \code{.trees} filenames as will be created by BEAST}
\usage{
create_default_trees_filenames(input_filename,
  beast2_path = get_default_beast2_path(), verbose = FALSE)
}
\arguments{
\item{input_filename}{the name of a BEAST2 input XML file.
This file usually has an \code{.xml} extension.}

\item{beast2_path}{name of either a BEAST2 binary file
(usually simply \code{beast})
or a BEAST2 jar file
(usually has a \code{.jar} extension).
Use \link{get_default_beast2_bin_path} to get
the default BEAST binary file's path
Use \link{get_default_beast2_jar_path} to get
the default BEAST jar file's path}

\item{verbose}{if TRUE, additional information is displayed, that
is potentially useful in debugging}
}
\value{
the default \code{.trees} filenames as will be created by BEAST
}
\description{
Create the default \code{.trees} filenames as will be created by BEAST
}
\examples{
  library(testthat)

  input_filename <- get_beastier_path("2_4.xml")

  if (is_beast2_installed()) {
    trees_filename <- create_default_trees_filenames(input_filename)
    expect_equal("test_output_0.trees", trees_filename)
  }
}
\author{
: Richèl J.C. Bilderbeek
}
