% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identify_analyte.R
\name{assign_analyte_id}
\alias{assign_analyte_id}
\title{Assign analyte ID}
\usage{
assign_analyte_id(.data, .parameter, .analyte_id, .column_name,
  .cluster_column_name = paste0("cluster_", .column_name),
  .desc = FALSE)
}
\arguments{
\item{.data}{The tidy data.frame, with indication of clusters}

\item{.parameter}{The parameter to order the cluster centers by}

\item{.analyte_id}{A character vector giving the name of the clusters.
The \strong{order} is important and must match the expected order of clusters.}

\item{.column_name}{A character giving the name of the column to hold the
analyte ID. If the column exists it will be silently dropped.}

\item{.cluster_column_name}{A character giving the name of the column where
the clusters are identified. Will be dropped from the data.frame.}

\item{.desc}{A boolean giving whether the sort order is descending.}
}
\value{
A \emph{data.frame} with cluster names instead of cluster ids.
}
\description{
Replace internal cluster IDs with informative analyte IDs
}
\examples{
\dontrun{
library(beadplexr)
library(magrittr)
library(ggplot2)

data("lplex")

.data <- lplex[[1]] \%>\%
  bp_clara(.parameter = c("FSC-A", "SSC-A"), .column_name = "analyte", .k = 2)

.data \%>\%
  beadplexr:::assign_analyte_id(.parameter = c("FSC-A", "SSC-A"),
                                   .analyte_id = c("A", "B"),
                                   .column_name = "pop name",
                                   .cluster_column_name = "analyte") \%>\%
  ggplot() +
  aes(x = `FSC-A`, y = `SSC-A`, colour = `pop name`) +
  geom_point()

.data \%>\%
  beadplexr:::assign_analyte_id(.parameter = c("FSC-A", "SSC-A"),
                                   .analyte_id = c("A", "B"),
                                   .column_name = "pop name",
                                   .cluster_column_name = "analyte", .desc = TRUE) \%>\%
  ggplot() +
  aes(x = `FSC-A`, y = `SSC-A`, colour = `pop name`) +
  geom_point()
}
}
\keyword{internal}
