% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualisations.R
\name{plot_concentrations}
\alias{plot_concentrations}
\alias{plot_std_curve}
\alias{plot_target_est_conc}
\alias{plot_estimate}
\title{Plot concentrations}
\usage{
plot_std_curve(.data, .model, .title = NULL, .parameter = "FL2.H",
  .concentration = "Concentration")

plot_target_est_conc(.data, .title = NULL, .concentration = "Calc.conc",
  .std_concentration = "Concentration")

plot_estimate(.sample_data, .standard_data, .model, .title = NULL,
  .parameter = "FL2.H", .concentration = "Concentration")
}
\arguments{
\item{.data}{A \code{data.frame} with the data to be plotted.}

\item{.model}{An object of class \code{drc} with the fitted dose-response model.}

\item{.title}{A character giving the title of the plot.}

\item{.parameter}{A character giving the name of the column with the MFI}

\item{.concentration}{A character giving the name of the column with the with the calculated concentrations.}

\item{.std_concentration}{A character giving the name of the column with the standard concentration.}

\item{.sample_data}{A \code{data.frame} with the calculated sample concentrations.}

\item{.standard_data}{A \code{data.frame} with the calculated standard
concentrations.}
}
\value{
A \code{ggplot}
}
\description{
Plot concentrations
}
\examples{

library(beadplexr)
library(drc)
data(ryegrass)

ryegrass_m <-
  fit_standard_curve(.data = ryegrass,
                     .parameter = "rootl",
                     .concentration = "conc")
recalc_std <-
  calculate_concentration(.data = ryegrass,
                          .model = ryegrass_m,
                          .parameter = "rootl")
sample_data <-
  calculate_concentration(.data = ryegrass[sample(1:nrow(ryegrass), 5),],
                          .model = ryegrass_m,
                          .parameter = "rootl")

plot_std_curve(ryegrass,
               ryegrass_m,
               .parameter = "rootl",
               .concentration = "conc")

plot_target_est_conc(.data = recalc_std,
                     .concentration = "Calc.conc",
                     .std_concentration = "conc")
plot_estimate(
  .sample_data = sample_data,
  .standard_data = ryegrass,
  .model = ryegrass_m,
  .parameter = "rootl",
  .concentration = "conc")

}
