% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_space.R
\name{optim_model_space_params}
\alias{optim_model_space_params}
\title{Finds MLE parameters for each model in the given model space}
\usage{
optim_model_space_params(
  df,
  timestamp_col,
  entity_col,
  dep_var_col,
  init_value,
  exact_value = FALSE,
  cl = NULL,
  control = list(trace = 2, maxit = 10000, fnscale = -1, REPORT = 100, scale = 0.05)
)
}
\arguments{
\item{df}{Data frame with data for the analysis.}

\item{timestamp_col}{The name of the column with time stamps.}

\item{entity_col}{Column with entities (e.g. countries).}

\item{dep_var_col}{Column with the dependent variable.}

\item{init_value}{The value with which the model space will be initialized.
This will be the starting point for the numerical optimization.}

\item{exact_value}{Whether the exact value of the likelihood should be
computed (\code{TRUE}) or just the proportional part (\code{FALSE}). Check
\link[bdsm]{sem_likelihood} for details.}

\item{cl}{An optional cluster object. If supplied, the function will use this
cluster for parallel processing. If \code{NULL} (the default),
\code{pbapply::pblapply} will run sequentially.}

\item{control}{a list of control parameters for the optimization which are
passed to \link[stats]{optim}. Default is
\code{list(trace = 2, maxit = 10000, fnscale = -1, REPORT = 100, scale = 0.05)}.}
}
\value{
List (or matrix) of parameters describing analyzed models.
}
\description{
Given a dataset and an initial value for parameters, initializes a model
space with parameters equal to the initial value for each model. Then for each
model performs a numerical optimization and finds parameters which maximize
the likelihood.
}
