% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEM_matrices.R
\name{SEM_dep_var_matrix}
\alias{SEM_dep_var_matrix}
\title{Matrix with dependent variable data for SEM representation}
\usage{
SEM_dep_var_matrix(df, timestamp_col, entity_col, dep_var_col)
}
\arguments{
\item{df}{Data frame with data for the SEM analysis.}

\item{timestamp_col}{Column which determines time periods. For now only
natural numbers can be used as timestamps}

\item{entity_col}{Column which determines entities (e.g. countries, people)}

\item{dep_var_col}{Column with dependent variable}
}
\value{
Matrix of size N x T where N is the number of entities considered and T is
the number of periods greater than or equal to the second lowest time stamp.
}
\description{
Create matrix which contains dependent variable data used in the Simultaneous
Equations Model (SEM) representation on the left hand side of the equations.
The matrix contains the data for time periods greater than or equal to the
second lowest time stamp. The matrix is then used to compute likelihood for
SEM analysis.
}
\examples{
set.seed(1)
df <- data.frame(
  entities = rep(1:4, 5),
  times = rep(seq(1960, 2000, 10), each = 4),
  dep_var = stats::rnorm(20), a = stats::rnorm(20), b = stats::rnorm(20)
)
SEM_dep_var_matrix(df, times, entities, dep_var)
}
